/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.tuples.Functions;

public class UniOnTermination<T>
extends UniOperator<T, T> {
    private final Functions.TriConsumer<T, Throwable, Boolean> callback;

    public UniOnTermination(Uni<T> upstream, Functions.TriConsumer<T, Throwable, Boolean> callback) {
        super(upstream);
        this.callback = callback;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnTerminationProcessor(subscriber));
    }

    private class UniOnTerminationProcessor
    extends UniOperatorProcessor<T, T> {
        public UniOnTerminationProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T item) {
            if (!this.isCancelled()) {
                try {
                    UniOnTermination.this.callback.accept(item, null, false);
                }
                catch (Throwable e) {
                    this.downstream.onFailure(e);
                    return;
                }
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                try {
                    UniOnTermination.this.callback.accept(null, failure, false);
                }
                catch (Throwable e) {
                    this.downstream.onFailure(new CompositeException(failure, e));
                    return;
                }
                this.downstream.onFailure(failure);
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                UniOnTermination.this.callback.accept(null, null, true);
            }
        }
    }
}

