/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;

public class CompleteTransactionCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 24;
    private XidImpl xid;
    private boolean commit;

    private CompleteTransactionCommand() {
        super(null);
    }

    public CompleteTransactionCommand(ByteString cacheName) {
        super(cacheName);
    }

    public CompleteTransactionCommand(ByteString cacheName, XidImpl xid, boolean commit) {
        super(cacheName);
        this.xid = xid;
        this.commit = commit;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        return recoveryManager.forceTransactionCompletion(this.xid, this.commit);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public byte getCommandId() {
        return 24;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        XidImpl.writeTo((ObjectOutput)output, (XidImpl)this.xid);
        output.writeBoolean(this.commit);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.xid = XidImpl.readFrom((ObjectInput)input);
        this.commit = input.readBoolean();
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", commit=" + this.commit + ", cacheName=" + this.cacheName + "} ";
    }
}

