/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=2)
public class MarshallableUserObject<T> {
    private final T object;

    @ProtoFactory
    MarshallableUserObject(byte[] bytes) {
        throw new IllegalStateException(this.getClass().getSimpleName() + " marshaller not overridden in SerializationContext");
    }

    public MarshallableUserObject(T object) {
        this.object = object;
    }

    @ProtoField(value=1)
    byte[] getBytes() {
        return Util.EMPTY_BYTE_ARRAY;
    }

    public T get() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshallableUserObject other = (MarshallableUserObject)o;
        return this.object != null ? this.object.equals(other.object) : other.object == null;
    }

    public int hashCode() {
        return this.object != null ? this.object.hashCode() : 0;
    }

    public static int size(int objectBytes) {
        int typeId = 2;
        int typeIdSize = MarshallableUserObject.tagSize(19, 1) + MarshallableUserObject.computeUInt32SizeNoTag(typeId);
        int userBytesFieldSize = MarshallableUserObject.tagSize(1, 2) + MarshallableUserObject.computeUInt32SizeNoTag(objectBytes) + objectBytes;
        int wrappedMessageSize = MarshallableUserObject.tagSize(17, 2) + MarshallableUserObject.computeUInt32SizeNoTag(objectBytes);
        return typeIdSize + userBytesFieldSize + wrappedMessageSize;
    }

    private static int tagSize(int fieldNumber, int wireType) {
        return MarshallableUserObject.computeUInt32SizeNoTag(fieldNumber << 3 | wireType);
    }

    private static int computeUInt32SizeNoTag(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        return (value & 0xF0000000) == 0 ? 4 : 5;
    }

    public static class Marshaller
    implements ProtobufTagMarshaller<MarshallableUserObject> {
        private final String typeName;
        private final org.infinispan.commons.marshall.Marshaller userMarshaller;

        public Marshaller(String typeName, org.infinispan.commons.marshall.Marshaller userMarshaller) {
            this.typeName = typeName;
            this.userMarshaller = userMarshaller;
        }

        public Class<MarshallableUserObject> getJavaClass() {
            return MarshallableUserObject.class;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public MarshallableUserObject read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            try {
                byte[] bytes = null;
                boolean done = false;
                block6: while (!done) {
                    int tag = in.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block6;
                        }
                        case 10: {
                            bytes = in.readByteArray();
                            continue block6;
                        }
                    }
                    if (in.skipField(tag)) continue;
                    done = true;
                }
                Object userObject = this.userMarshaller.objectFromByteBuffer(bytes);
                return new MarshallableUserObject<Object>(userObject);
            }
            catch (ClassNotFoundException e) {
                throw new MarshallingException((Throwable)e);
            }
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, MarshallableUserObject marshallableUserObject) throws IOException {
            try {
                Object userObject = marshallableUserObject.get();
                byte[] bytes = this.userMarshaller.objectToByteBuffer(userObject);
                ctx.getWriter().writeBytes(1, bytes);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException((Throwable)e);
            }
        }
    }
}

