/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.infinispan.commons.util.AbstractImmutableIntSet;
import org.infinispan.commons.util.IntSet;

class SingletonIntSet
extends AbstractImmutableIntSet {
    final int value;

    SingletonIntSet(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be 0 or greater");
        }
        this.value = value;
    }

    @Override
    public boolean contains(int i) {
        return this.value == i;
    }

    @Override
    public boolean containsAll(IntSet set) {
        int size = set.size();
        return size == 0 || size == 1 && set.contains(this.value);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && (Integer)o == this.value;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new SingleIntIterator();
    }

    @Override
    public byte[] toBitSet() {
        int offset = this.value >>> 3;
        byte[] array = new byte[offset + 1];
        int lastBitOffset = this.value > 8 ? this.value % 8 : this.value;
        array[offset] = (byte)(128 >>> 7 - lastBitOffset);
        return array;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[]{this.value};
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (!(a instanceof Integer[])) {
            throw new IllegalArgumentException("Only Integer arrays are supported");
        }
        T[] r = a.length >= 1 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
        r[0] = this.value;
        if (r.length > 1) {
            r[1] = null;
        }
        return r;
    }

    @Override
    public int[] toIntArray() {
        int[] array = new int[]{this.value};
        return array;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof IntSet) {
            return this.containsAll((IntSet)c);
        }
        return c.size() == 1 && c.contains(this.value);
    }

    @Override
    public IntStream intStream() {
        return IntStream.of(this.value);
    }

    @Override
    public void forEach(IntConsumer action) {
        action.accept(this.value);
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        if (action instanceof IntConsumer) {
            this.forEach((IntConsumer)((Object)action));
        }
        action.accept((Integer)this.value);
    }

    @Override
    public Spliterator.OfInt intSpliterator() {
        return new SingletonSpliterator();
    }

    @Override
    public Spliterator<Integer> spliterator() {
        return new SingletonSpliterator();
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Set)) {
            return false;
        }
        if (o instanceof IntSet) {
            IntSet intSet = (IntSet)o;
            return intSet.size() == 1 && intSet.contains(this.value);
        }
        Set set = (Set)o;
        return set.size() == 1 && set.contains(this.value);
    }

    public String toString() {
        return "{" + this.value + "}";
    }

    private class SingletonSpliterator
    implements Spliterator.OfInt {
        boolean consumed = false;

        private SingletonSpliterator() {
        }

        @Override
        public Spliterator.OfInt trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 1L;
        }

        @Override
        public int characteristics() {
            return 1361;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (!this.consumed) {
                this.consumed = true;
                action.accept(SingletonIntSet.this.value);
                return true;
            }
            return false;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return null;
        }
    }

    private class SingleIntIterator
    implements PrimitiveIterator.OfInt {
        boolean available = true;

        private SingleIntIterator() {
        }

        @Override
        public int nextInt() {
            if (!this.available) {
                throw new NoSuchElementException();
            }
            this.available = false;
            return SingletonIntSet.this.value;
        }

        @Override
        public boolean hasNext() {
            return this.available;
        }
    }
}

