/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;

public final class JBossWebservicesMetaData {
    private final String contextRoot;
    private final String configName;
    private final String configFile;
    private final Map<String, String> properties;
    private final List<JBossPortComponentMetaData> portComponents;
    private final List<JBossWebserviceDescriptionMetaData> webserviceDescriptions;
    private final URL descriptorURL;

    public JBossWebservicesMetaData(String contextRoot, String configName, String configFile, URL descriptorURL, Map<String, String> properties, List<JBossPortComponentMetaData> portComponents, List<JBossWebserviceDescriptionMetaData> webserviceDescriptions) {
        this.contextRoot = contextRoot;
        this.configName = configName;
        this.configFile = configFile;
        this.descriptorURL = descriptorURL;
        this.properties = properties != null && !properties.isEmpty() ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
        this.portComponents = portComponents != null && !portComponents.isEmpty() ? Collections.unmodifiableList(portComponents) : Collections.emptyList();
        this.webserviceDescriptions = webserviceDescriptions != null && !webserviceDescriptions.isEmpty() ? Collections.unmodifiableList(webserviceDescriptions) : Collections.emptyList();
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public JBossPortComponentMetaData[] getPortComponents() {
        JBossPortComponentMetaData[] array = new JBossPortComponentMetaData[this.portComponents.size()];
        this.portComponents.toArray(array);
        return array;
    }

    public JBossWebserviceDescriptionMetaData[] getWebserviceDescriptions() {
        JBossWebserviceDescriptionMetaData[] array = new JBossWebserviceDescriptionMetaData[this.webserviceDescriptions.size()];
        this.webserviceDescriptions.toArray(array);
        return array;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static JBossWebservicesMetaData merge(JBossWebservicesMetaData base, JBossWebservicesMetaData override) {
        List<JBossWebserviceDescriptionMetaData> webserviceDescriptions;
        List<JBossPortComponentMetaData> portComponents;
        Map<String, String> properties;
        if (base == null) {
            return override;
        }
        if (override == null) {
            return base;
        }
        if (base.properties.isEmpty()) {
            properties = override.properties;
        } else if (override.properties.isEmpty()) {
            properties = base.properties;
        } else {
            properties = new HashMap<String, String>();
            properties.putAll(base.properties);
            properties.putAll(override.properties);
            properties = Collections.unmodifiableMap(properties);
        }
        if (base.portComponents.isEmpty()) {
            portComponents = override.portComponents;
        } else if (override.portComponents.isEmpty()) {
            portComponents = base.portComponents;
        } else {
            HashMap<String, JBossPortComponentMetaData> portComponentsMap = new HashMap<String, JBossPortComponentMetaData>();
            for (JBossPortComponentMetaData jpcmd : base.portComponents) {
                portComponentsMap.put(jpcmd.getPortComponentName(), jpcmd);
            }
            for (JBossPortComponentMetaData jpcmd : override.portComponents) {
                JBossPortComponentMetaData b = (JBossPortComponentMetaData)portComponentsMap.get(jpcmd.getPortComponentName());
                if (b != null) {
                    portComponentsMap.put(jpcmd.getPortComponentName(), JBossPortComponentMetaData.merge(b, jpcmd));
                    continue;
                }
                portComponentsMap.put(jpcmd.getPortComponentName(), jpcmd);
            }
            portComponents = Collections.unmodifiableList(new ArrayList(portComponentsMap.values()));
        }
        if (base.webserviceDescriptions.isEmpty()) {
            webserviceDescriptions = override.webserviceDescriptions;
        } else if (override.webserviceDescriptions.isEmpty()) {
            webserviceDescriptions = base.webserviceDescriptions;
        } else {
            HashMap<String, JBossWebserviceDescriptionMetaData> webserviceDescriptionsMap = new HashMap<String, JBossWebserviceDescriptionMetaData>();
            for (JBossWebserviceDescriptionMetaData jpcmd : base.webserviceDescriptions) {
                webserviceDescriptionsMap.put(jpcmd.getWebserviceDescriptionName(), jpcmd);
            }
            for (JBossWebserviceDescriptionMetaData jpcmd : override.webserviceDescriptions) {
                JBossWebserviceDescriptionMetaData b = (JBossWebserviceDescriptionMetaData)webserviceDescriptionsMap.get(jpcmd.getWebserviceDescriptionName());
                if (b != null) {
                    webserviceDescriptionsMap.put(jpcmd.getWebserviceDescriptionName(), JBossWebserviceDescriptionMetaData.merge(b, jpcmd));
                    continue;
                }
                webserviceDescriptionsMap.put(jpcmd.getWebserviceDescriptionName(), jpcmd);
            }
            webserviceDescriptions = Collections.unmodifiableList(new ArrayList(webserviceDescriptionsMap.values()));
        }
        return new JBossWebservicesMetaData(override.contextRoot != null ? override.contextRoot : base.contextRoot, override.configName != null ? override.configName : base.configName, override.configFile != null ? override.configFile : base.configFile, override.descriptorURL != null ? override.descriptorURL : base.descriptorURL, properties, portComponents, webserviceDescriptions);
    }
}

