/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageConsumer;

public class ActiveMQRAMessageListener
implements MessageListener {
    private final MessageListener listener;
    private final ActiveMQRAMessageConsumer consumer;

    public ActiveMQRAMessageListener(MessageListener listener, ActiveMQRAMessageConsumer consumer) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + listener + ", " + consumer + ")");
        }
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("onMessage(" + message + ")");
        }
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

