/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class BigIntegerType
extends AbstractPrimitiveType<BigInteger> {
    private static final BigInteger BIG_BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger BIG_BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger BIG_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger BIG_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private BigIntegerEncoding _BigIntegerEncoding;
    private BigIntegerEncoding _smallBigIntegerEncoding;

    BigIntegerType(EncoderImpl encoder, DecoderImpl decoder) {
        this._BigIntegerEncoding = new AllBigIntegerEncoding(encoder, decoder);
        this._smallBigIntegerEncoding = new SmallBigIntegerEncoding(encoder, decoder);
        encoder.register(BigInteger.class, this);
    }

    @Override
    public Class<BigInteger> getTypeClass() {
        return BigInteger.class;
    }

    public BigIntegerEncoding getEncoding(BigInteger l) {
        return l.compareTo(BIG_BYTE_MIN) >= 0 && l.compareTo(BIG_BYTE_MAX) <= 0 ? this._smallBigIntegerEncoding : this._BigIntegerEncoding;
    }

    @Override
    public BigIntegerEncoding getCanonicalEncoding() {
        return this._BigIntegerEncoding;
    }

    @Override
    public Collection<BigIntegerEncoding> getAllEncodings() {
        return Arrays.asList(this._smallBigIntegerEncoding, this._BigIntegerEncoding);
    }

    private long longValueExact(BigInteger val) {
        if (val.compareTo(BIG_LONG_MIN) < 0 || val.compareTo(BIG_LONG_MAX) > 0) {
            throw new ArithmeticException("cannot encode BigInteger not representable as long");
        }
        return val.longValue();
    }

    private class SmallBigIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<BigInteger>
    implements BigIntegerEncoding {
        public SmallBigIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 85;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        @Override
        public void write(BigInteger l) {
            this.writeConstructor();
            this.getEncoder().writeRaw(l.byteValue());
        }

        @Override
        public BigInteger readPrimitiveValue() {
            return BigInteger.valueOf(this.getDecoder().readRawByte());
        }

        @Override
        public BigIntegerType getType() {
            return BigIntegerType.this;
        }

        @Override
        public void writeValue(BigInteger val) {
            this.getEncoder().writeRaw(val.byteValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<BigInteger> encoder) {
            return encoder == this;
        }

        @Override
        public BigInteger readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    private class AllBigIntegerEncoding
    extends FixedSizePrimitiveTypeEncoding<BigInteger>
    implements BigIntegerEncoding {
        public AllBigIntegerEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -127;
        }

        @Override
        public BigIntegerType getType() {
            return BigIntegerType.this;
        }

        @Override
        public void writeValue(BigInteger val) {
            this.getEncoder().writeRaw(BigIntegerType.this.longValueExact(val));
        }

        @Override
        public void write(BigInteger l) {
            this.writeConstructor();
            this.getEncoder().writeRaw(BigIntegerType.this.longValueExact(l));
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<BigInteger> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public BigInteger readValue() {
            return this.readPrimitiveValue();
        }

        @Override
        public BigInteger readPrimitiveValue() {
            return BigInteger.valueOf(this.getDecoder().readLong());
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    public static interface BigIntegerEncoding
    extends PrimitiveTypeEncoding<BigInteger> {
        public void write(BigInteger var1);

        @Override
        public void writeValue(BigInteger var1);

        public BigInteger readPrimitiveValue();
    }
}

