/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class UnsignedByteElement
extends AtomicElement<UnsignedByte> {
    private final UnsignedByte _value;

    UnsignedByteElement(Element parent, Element prev, UnsignedByte ub) {
        super(parent, prev);
        this._value = ub;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 1 : 2;
    }

    @Override
    public UnsignedByte getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.UBYTE;
    }

    @Override
    public int encode(ByteBuffer b) {
        if (this.isElementOfArray()) {
            if (b.hasRemaining()) {
                b.put(this._value.byteValue());
                return 1;
            }
        } else if (b.remaining() >= 2) {
            b.put((byte)80);
            b.put(this._value.byteValue());
            return 2;
        }
        return 0;
    }
}

