/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server.sasl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.UnaryOperator;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.sasl.ElytronMessages;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;
import org.wildfly.security.sasl.util.AuthenticationTimeoutSaslServerFactory;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.sasl.util.SecurityIdentitySaslServerFactory;
import org.wildfly.security.sasl.util.SetMechanismInformationSaslServerFactory;
import org.wildfly.security.sasl.util.TrustManagerSaslServerFactory;

public final class SaslAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<SaslServer, SaslServerFactory, SaslException> {
    private final SaslServerFactory saslServerFactory;
    static final Map<String, String> QUERY_ALL = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");

    SaslAuthenticationFactory(SecurityDomain securityDomain, MechanismConfigurationSelector mechanismConfigurationSelector, SaslServerFactory saslServerFactory) {
        super(securityDomain, mechanismConfigurationSelector, (Object)saslServerFactory);
        this.saslServerFactory = saslServerFactory;
    }

    protected SaslServer doCreate(String name, CallbackHandler callbackHandler, UnaryOperator<SaslServerFactory> factoryTransformation) throws SaslException {
        SaslServer server = new SecurityIdentitySaslServerFactory((SaslServerFactory)factoryTransformation.apply((SaslServerFactory)this.getFactory())).createSaslServer(name, "unknown", null, QUERY_ALL, callbackHandler);
        ElytronMessages.log.tracef("Created SaslServer [%s] for mechanism [%s]", server, name);
        return server;
    }

    protected Collection<String> getAllSupportedMechNames() {
        String[] names = this.saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return Arrays.asList(names);
    }

    protected Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceTypes((String)mechName);
    }

    protected Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> evidenceType, String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceAlgorithms((String)mechName, evidenceType);
    }

    protected Collection<Class<? extends Credential>> getSupportedCredentialTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialTypes((String)mechName);
    }

    protected Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> credentialType, String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialAlgorithms((String)mechName, credentialType);
    }

    protected boolean usesCredentials(String mechName) {
        return SaslMechanismInformation.needsServerCredentials((String)mechName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<SaslServer, SaslServerFactory, SaslException> {
        private ScheduledExecutorService scheduledExecutorService;

        Builder() {
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        public Builder setMechanismConfigurationSelector(MechanismConfigurationSelector mechanismConfigurationSelector) {
            super.setMechanismConfigurationSelector(mechanismConfigurationSelector);
            return this;
        }

        public Builder setFactory(SaslServerFactory factory) {
            super.setFactory((Object)factory);
            return this;
        }

        public Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }

        public SaslAuthenticationFactory build() {
            AuthenticationCompleteCallbackSaslServerFactory factory = new AuthenticationCompleteCallbackSaslServerFactory((SaslServerFactory)new SetMechanismInformationSaslServerFactory((SaslServerFactory)this.getFactory()));
            if (!factory.delegatesThrough(TrustManagerSaslServerFactory.class)) {
                factory = new TrustManagerSaslServerFactory((SaslServerFactory)factory, null);
            }
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = SecurityDomain.getScheduledExecutorService();
            }
            factory = new AuthenticationTimeoutSaslServerFactory((SaslServerFactory)factory, this.scheduledExecutorService);
            return new SaslAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurationSelector(), (SaslServerFactory)factory);
        }
    }
}

