/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.aggregator.HistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class DoubleHistogramAggregator
implements Aggregator<HistogramAccumulation> {
    private final double[] boundaries;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    public DoubleHistogramAggregator(double[] boundaries, Supplier<ExemplarReservoir> reservoirSupplier) {
        this.boundaries = boundaries;
        ArrayList<Double> boundaryList = new ArrayList<Double>(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add(v);
        }
        this.boundaryList = Collections.unmodifiableList(boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<HistogramAccumulation> createHandle() {
        return new Handle(this.boundaries, this.reservoirSupplier.get());
    }

    @Override
    public HistogramAccumulation merge(HistogramAccumulation previous, HistogramAccumulation current) {
        long[] previousCounts = previous.getCounts();
        long[] mergedCounts = new long[previousCounts.length];
        for (int i = 0; i < previousCounts.length; ++i) {
            mergedCounts[i] = previousCounts[i] + current.getCounts()[i];
        }
        return HistogramAccumulation.create(previous.getSum() + current.getSum(), mergedCounts, current.getExemplars());
    }

    @Override
    public HistogramAccumulation diff(HistogramAccumulation previous, HistogramAccumulation current) {
        long[] previousCounts = previous.getCounts();
        long[] diffedCounts = new long[previousCounts.length];
        for (int i = 0; i < previousCounts.length; ++i) {
            diffedCounts[i] = current.getCounts()[i] - previousCounts[i];
        }
        return HistogramAccumulation.create(current.getSum() - previous.getSum(), diffedCounts, current.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor metricDescriptor, Map<Attributes, HistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleHistogram(resource, instrumentationLibraryInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getUnit(), ImmutableHistogramData.create(temporality, MetricDataUtils.toDoubleHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos, this.boundaryList)));
    }

    static final class Handle
    extends AggregatorHandle<HistogramAccumulation> {
        private final double[] boundaries;
        private double sum;
        private final long[] counts;
        private final ReentrantLock lock = new ReentrantLock();

        Handle(double[] boundaries, ExemplarReservoir reservoir) {
            super(reservoir);
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            this.lock.lock();
            try {
                HistogramAccumulation acc = HistogramAccumulation.create(this.sum, Arrays.copyOf(this.counts, this.counts.length), exemplars);
                this.sum = 0.0;
                Arrays.fill(this.counts, 0L);
                HistogramAccumulation histogramAccumulation = acc;
                return histogramAccumulation;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            this.lock.lock();
            try {
                this.sum += value;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

