/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import java.sql.Driver;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.SimpleConnectionFactoryConfiguration;

public class SimpleConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<SimpleConnectionFactoryConfiguration> {
    private final AttributeSet attributes = SimpleConnectionFactoryConfiguration.attributeSet();

    public SimpleConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> connectionUrl(String connectionUrl) {
        this.attributes.attribute(SimpleConnectionFactoryConfiguration.CONNECTION_URL).set((Object)connectionUrl);
        return this;
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> driverClass(Class<? extends Driver> driverClass) {
        this.attributes.attribute(SimpleConnectionFactoryConfiguration.DRIVER_CLASS).set((Object)driverClass.getName());
        return this;
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> driverClass(String driverClass) {
        this.attributes.attribute(SimpleConnectionFactoryConfiguration.DRIVER_CLASS).set((Object)driverClass);
        return this;
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> username(String username) {
        this.attributes.attribute(SimpleConnectionFactoryConfiguration.USERNAME).set((Object)username);
        return this;
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> password(String password) {
        this.attributes.attribute(SimpleConnectionFactoryConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    public void validate() {
        String connectionUrl = (String)this.attributes.attribute(SimpleConnectionFactoryConfiguration.CONNECTION_URL).get();
        if (connectionUrl == null) {
            throw new CacheConfigurationException("A connectionUrl has not been specified");
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public SimpleConnectionFactoryConfiguration create() {
        return new SimpleConnectionFactoryConfiguration(this.attributes.protect());
    }

    public SimpleConnectionFactoryConfigurationBuilder<S> read(SimpleConnectionFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

