/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.sfbasic;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.common.array.Arrays2;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.sfbasic.IdentityManager;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.http.UsernamePasswordAuthenticationMechanism;

final class BasicAuthenticationMechanism
extends UsernamePasswordAuthenticationMechanism {
    static final String SILENT = "silent";
    private static final String CHALLENGE_PREFIX = "Basic ";
    private static final int PREFIX_LENGTH = "Basic ".length();
    private final IdentityManager identityManager;
    private final boolean includeCharset;
    private final String configuredRealm;
    private final boolean silent;

    BasicAuthenticationMechanism(CallbackHandler callbackHandler, IdentityManager identityManager, String configuredRealm, boolean silent, boolean includeCharset) {
        super((CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler));
        this.identityManager = identityManager;
        this.includeCharset = includeCharset;
        this.configuredRealm = configuredRealm;
        this.silent = silent;
    }

    public String getMechanismName() {
        return "STATEFUL_BASIC";
    }

    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        String displayRealmName;
        String mechanismRealm = null;
        String[] realms = null;
        AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
        try {
            this.callbackHandler.handle(new Callback[]{availableRealmsCallback});
            realms = availableRealmsCallback.getRealmNames();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (HttpAuthenticationException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.httpBasic.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toHttpAuthenticationException();
        }
        if (this.configuredRealm != null) {
            displayRealmName = this.configuredRealm;
        } else if (realms != null && realms.length > 0) {
            mechanismRealm = displayRealmName = realms[0];
        } else {
            displayRealmName = request.getFirstRequestHeaderValue("Host");
        }
        if (mechanismRealm == null && realms != null && realms.length > 0) {
            for (String current : realms) {
                if (!displayRealmName.equals(current)) continue;
                mechanismRealm = displayRealmName;
            }
            if (mechanismRealm == null) {
                mechanismRealm = realms[0];
            }
        }
        if (this.attemptReAuthentication(request)) {
            return;
        }
        List authorizationValues = request.getRequestHeaderValues("Authorization");
        if (authorizationValues != null) {
            for (String current : authorizationValues) {
                if (!current.regionMatches(true, 0, CHALLENGE_PREFIX, 0, PREFIX_LENGTH)) continue;
                byte[] decodedValue = ByteIterator.ofBytes((byte[])current.substring(PREFIX_LENGTH).getBytes(StandardCharsets.UTF_8)).asUtf8String().base64Decode().drain();
                int colonPos = Arrays2.indexOf((byte[])decodedValue, (int)58);
                if (colonPos <= 0) {
                    request.authenticationFailed(ElytronMessages.httpBasic.incorrectlyFormattedHeader("Authorization"), response -> this.prepareResponse(request, displayRealmName, response));
                    return;
                }
                ByteBuffer usernameBytes = ByteBuffer.wrap(decodedValue, 0, colonPos);
                ByteBuffer passwordBytes = ByteBuffer.wrap(decodedValue, colonPos + 1, decodedValue.length - colonPos - 1);
                CharBuffer usernameChars = StandardCharsets.UTF_8.decode(usernameBytes);
                CharBuffer passwordChars = StandardCharsets.UTF_8.decode(passwordBytes);
                char[] password = new char[passwordChars.length()];
                passwordChars.get(password);
                try {
                    String username = usernameChars.toString();
                    if (this.authenticate(mechanismRealm, username, password)) {
                        ElytronMessages.httpBasic.tracef("User %s authenticated successfully!", (Object)username);
                        BasicIdentityCache identityCache = new BasicIdentityCache();
                        if (this.authorize(username, identityCache)) {
                            ElytronMessages.httpBasic.debugf("User %s authorization succeeded!", (Object)username);
                            this.succeed();
                            request.authenticationComplete((HttpServerMechanismsResponder)identityCache, identityCache::remove);
                            return;
                        }
                        ElytronMessages.httpBasic.debugf("User %s authorization failed.", (Object)username);
                        this.fail();
                        request.authenticationFailed(ElytronMessages.httpBasic.authorizationFailed(username), response -> this.prepareResponse(request, displayRealmName, response));
                        return;
                    }
                    ElytronMessages.httpBasic.debugf("User %s authentication failed.", (Object)username);
                    this.fail();
                    request.authenticationFailed(ElytronMessages.httpBasic.authenticationFailed(username, "STATEFUL_BASIC"), response -> this.prepareResponse(request, displayRealmName, response));
                    return;
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException((Throwable)e);
                }
                finally {
                    Arrays.fill(password, '\u0000');
                    if (passwordChars.hasArray()) {
                        Arrays.fill(passwordChars.array(), '\u0000');
                    }
                }
            }
        }
        request.noAuthenticationInProgress(response -> this.prepareResponse(request, displayRealmName, response));
    }

    private boolean attemptReAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        String sessionID = null;
        for (HttpServerCookie cookie : request.getCookies()) {
            if (!"ELYTRON_AUTH_SESSION".equals(cookie.getName())) continue;
            sessionID = cookie.getValue();
            break;
        }
        if (sessionID != null) {
            BasicIdentityCache identityCache = new BasicIdentityCache(sessionID);
            CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback((IdentityCache)identityCache);
            try {
                this.callbackHandler.handle(new Callback[]{authorizeCallback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new HttpAuthenticationException((Throwable)e);
            }
            if (authorizeCallback.isAuthorized()) {
                try {
                    this.succeed();
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException((Throwable)e);
                }
                ElytronMessages.httpBasic.tracef("Authorized existing session '%s'.", (Object)sessionID);
                request.authenticationComplete((HttpServerMechanismsResponder)identityCache, identityCache::remove);
                request.resumeRequest();
                return true;
            }
            ElytronMessages.httpBasic.tracef("Unable to authorize session '%s'", (Object)sessionID);
        } else {
            ElytronMessages.httpBasic.trace((Object)"No authentication session cookie found.");
        }
        return false;
    }

    private boolean authorize(String username, IdentityCache identityCache) throws HttpAuthenticationException {
        CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback(username, identityCache);
        try {
            this.callbackHandler.handle(new Callback[]{authorizeCallback});
            return authorizeCallback.isAuthorized();
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException((Throwable)e);
        }
    }

    private void prepareResponse(HttpServerRequest request, String realmName, HttpServerResponse response) {
        String authHeader;
        if (this.silent && (authHeader = request.getFirstRequestHeaderValue("Authorization")) == null) {
            ElytronMessages.httpBasic.tracef("BASIC authentication mechanism ignored - configuration is set to silent and request does not contain Authorization header", new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder(CHALLENGE_PREFIX);
        sb.append("realm").append("=\"").append(realmName).append("\"");
        if (this.includeCharset) {
            sb.append(", ").append("charset").append("=\"UTF-8\"");
        }
        response.addResponseHeader("WWW-Authenticate", sb.toString());
        response.setStatusCode(401);
    }

    private static HttpServerCookie createCookie(final String name, final String value) {
        return new HttpServerCookie(){

            public boolean isSecure() {
                return false;
            }

            public boolean isHttpOnly() {
                return false;
            }

            public int getVersion() {
                return 0;
            }

            public String getValue() {
                return value;
            }

            public String getPath() {
                return "/";
            }

            public String getName() {
                return name;
            }

            public int getMaxAge() {
                return -1;
            }

            public String getDomain() {
                return null;
            }
        };
    }

    private final class BasicIdentityCache
    implements IdentityCache,
    HttpServerMechanismsResponder {
        private String sessionID;

        BasicIdentityCache() {
        }

        BasicIdentityCache(String sessionID) {
            this.sessionID = sessionID;
        }

        public void sendResponse(HttpServerResponse response) throws HttpAuthenticationException {
            if (this.sessionID != null) {
                ElytronMessages.httpBasic.tracef("Sending session cookie for '%s'", (Object)this.sessionID);
                response.setResponseCookie(BasicAuthenticationMechanism.createCookie("ELYTRON_AUTH_SESSION", this.sessionID));
            }
        }

        public void put(SecurityIdentity identity) {
            CachedIdentity cachedIdentity = new CachedIdentity(BasicAuthenticationMechanism.CHALLENGE_PREFIX, false, identity);
            this.sessionID = BasicAuthenticationMechanism.this.identityManager.storeIdentity(this.sessionID, cachedIdentity);
        }

        public CachedIdentity get() {
            if (this.sessionID != null) {
                return BasicAuthenticationMechanism.this.identityManager.retrieveIdentity(this.sessionID);
            }
            return null;
        }

        public CachedIdentity remove() {
            if (this.sessionID != null) {
                return BasicAuthenticationMechanism.this.identityManager.removeIdentity(this.sessionID);
            }
            return null;
        }
    }
}

