/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.marshalling.protostream.FunctionalMarshaller;
import org.wildfly.common.function.ExceptionFunction;

public class InstantMarshaller
extends FunctionalMarshaller<Instant, Duration> {
    private static final ExceptionFunction<Instant, Duration, IOException> DURATION_SINCE_EPOCH = new ExceptionFunction<Instant, Duration, IOException>(){

        public Duration apply(Instant instant) {
            return Duration.ofSeconds(instant.getEpochSecond(), instant.getNano());
        }
    };
    private static final ExceptionFunction<Duration, Instant, IOException> FACTORY = new ExceptionFunction<Duration, Instant, IOException>(){

        public Instant apply(Duration duration) {
            return Instant.ofEpochSecond(duration.getSeconds(), duration.getNano());
        }
    };

    public InstantMarshaller() {
        super(Instant.class, Duration.class, DURATION_SINCE_EPOCH, FACTORY);
    }
}

