/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum LocalTimeMarshaller implements FieldSetMarshaller<LocalTime, LocalTime>
{
    INSTANCE;

    private static final int HOURS_OF_DAY_INDEX = 0;
    private static final int MINUTES_OF_DAY_INDEX = 1;
    private static final int SECONDS_OF_DAY_INDEX = 2;
    private static final int MILLIS_INDEX = 3;
    private static final int NANOS_INDEX = 4;
    private static final int FIELDS = 5;

    @Override
    public LocalTime getBuilder() {
        return LocalTime.MIDNIGHT;
    }

    @Override
    public int getFields() {
        return 5;
    }

    @Override
    public LocalTime readField(ProtoStreamReader reader, int index, LocalTime time) throws IOException {
        switch (index) {
            case 0: {
                return time.with(ChronoField.HOUR_OF_DAY, reader.readUInt32());
            }
            case 1: {
                return time.with(ChronoField.MINUTE_OF_DAY, reader.readUInt32());
            }
            case 2: {
                return time.with(ChronoField.SECOND_OF_DAY, reader.readUInt32());
            }
            case 3: {
                return time.with(ChronoField.MILLI_OF_SECOND, reader.readUInt32());
            }
            case 4: {
                return time.withNano(reader.readUInt32());
            }
        }
        return time;
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, LocalTime time) throws IOException {
        int nanos;
        int secondOfDay = time.toSecondOfDay();
        if (secondOfDay > 0) {
            if (secondOfDay % 60 == 0) {
                int minutesOfDay = secondOfDay / 60;
                if (minutesOfDay % 60 == 0) {
                    int hoursOfDay = minutesOfDay / 60;
                    writer.writeUInt32(startIndex + 0, hoursOfDay);
                } else {
                    writer.writeUInt32(startIndex + 1, minutesOfDay);
                }
            } else {
                writer.writeUInt32(startIndex + 2, secondOfDay);
            }
        }
        if ((nanos = time.getNano()) > 0) {
            if (nanos % 1000000 == 0) {
                writer.writeUInt32(startIndex + 3, time.get(ChronoField.MILLI_OF_SECOND));
            } else {
                writer.writeUInt32(startIndex + 4, nanos);
            }
        }
    }
}

