/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util.concurrent;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.SimpleFunctionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedMapMarshaller;
import org.wildfly.common.function.ExceptionFunction;

public class ConcurrentSortedMapMarshaller<T extends ConcurrentMap<Object, Object> & SortedMap<Object, Object>>
extends SimpleFunctionalMarshaller<T, SortedMap<Object, Object>> {
    private static final ProtoStreamMarshaller<SortedMap<Object, Object>> MARSHALLER = new SortedMapMarshaller<SortedMap>(TreeMap::new);

    public ConcurrentSortedMapMarshaller(final Function<Comparator<? super Object>, T> factory) {
        super(((ConcurrentMap)factory.apply(Comparator.naturalOrder())).getClass(), MARSHALLER, new ExceptionFunction<SortedMap<Object, Object>, T, IOException>(){

            public T apply(SortedMap<Object, Object> map) {
                ConcurrentMap result = (ConcurrentMap)factory.apply(map.comparator());
                result.putAll(map);
                return result;
            }
        });
    }
}

