/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.jaxrs.ReaderInterceptorRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.WriterInterceptorRegistryImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;

public class CommonProviders {
    protected ResteasyProviderFactoryImpl rpf;
    protected boolean lockSnapshots;
    protected boolean attachedMessageBodyReaders;
    protected volatile MediaTypeMap<SortedKey<MessageBodyReader>> messageBodyReaders;
    protected boolean attachedMessageBodyWriters;
    protected volatile MediaTypeMap<SortedKey<MessageBodyWriter>> messageBodyWriters;
    protected boolean attachedReaderInterceptors;
    protected volatile JaxrsInterceptorRegistry<ReaderInterceptor> readerInterceptorRegistry;
    protected boolean attachedWriterInterceptors;
    protected volatile JaxrsInterceptorRegistry<WriterInterceptor> writerInterceptorRegistry;
    protected boolean attachedFeatures;
    protected volatile Set<DynamicFeature> dynamicFeatures;

    CommonProviders() {
    }

    public CommonProviders(ResteasyProviderFactoryImpl rpf) {
        this.rpf = rpf;
    }

    public CommonProviders(ResteasyProviderFactoryImpl rpf, CommonProviders parent) {
        this(rpf);
        this.lockSnapshots = true;
        if (parent.messageBodyReaders != null) {
            this.messageBodyReaders = parent.messageBodyReaders;
            this.attachedMessageBodyReaders = true;
        }
        if (parent.messageBodyWriters != null) {
            this.messageBodyWriters = parent.messageBodyWriters;
            this.attachedMessageBodyWriters = true;
        }
        if (parent.readerInterceptorRegistry != null) {
            this.readerInterceptorRegistry = parent.readerInterceptorRegistry;
            this.attachedReaderInterceptors = true;
        }
        if (parent.writerInterceptorRegistry != null) {
            this.writerInterceptorRegistry = parent.writerInterceptorRegistry;
            this.attachedWriterInterceptors = true;
        }
        if (parent.dynamicFeatures != null) {
            this.dynamicFeatures = parent.dynamicFeatures;
            this.attachedFeatures = true;
        }
    }

    protected void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts) {
        int priority;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider);
                this.addMessageBodyReader((MessageBodyReader)Utils.createProviderInstance(this.rpf, provider), provider, priority, isBuiltin);
                newContracts.put(MessageBodyReader.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider);
                this.addMessageBodyWriter((MessageBodyWriter)Utils.createProviderInstance(this.rpf, provider), provider, priority, isBuiltin);
                newContracts.put(MessageBodyWriter.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider);
            this.addReaderInterceptor(provider, priority);
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider);
            this.addWriterInterceptor(provider, priority);
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider);
            this.addDynamicFeature(provider);
            newContracts.put(DynamicFeature.class, priority);
        }
    }

    protected void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts) {
        Object registry;
        int priority;
        if (Utils.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider.getClass());
                this.addMessageBodyReader((MessageBodyReader)provider, provider.getClass(), priority, builtIn);
                newContracts.put(MessageBodyReader.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (Utils.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider.getClass());
                this.addMessageBodyWriter((MessageBodyWriter)provider, provider.getClass(), priority, builtIn);
                newContracts.put(MessageBodyWriter.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (Utils.isA(provider, ReaderInterceptor.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider.getClass());
            registry = this.getReaderInterceptorRegistryForWrite();
            registry.registerSingleton((Object)((ReaderInterceptor)provider), priority);
            this.attachedReaderInterceptors = false;
            this.readerInterceptorRegistry = registry;
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (Utils.isA(provider, WriterInterceptor.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider.getClass());
            registry = this.getWriterInterceptorRegistryForWrite();
            registry.registerSingleton((Object)((WriterInterceptor)provider), priority);
            this.attachedWriterInterceptors = false;
            this.writerInterceptorRegistry = registry;
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (Utils.isA(provider, DynamicFeature.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, DynamicFeature.class, provider.getClass());
            registry = this.getDynamicFeaturesForWrite();
            registry.add((DynamicFeature)((DynamicFeature)provider));
            this.attachedFeatures = false;
            this.dynamicFeatures = registry;
            newContracts.put(DynamicFeature.class, priority);
        }
    }

    protected void addMessageBodyReader(MessageBodyReader provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        SortedKey<MessageBodyReader> key = new SortedKey<MessageBodyReader>(MessageBodyReader.class, provider, providerClass, priority, isBuiltin);
        Utils.injectProperties(this.rpf, providerClass, provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                registry.add(consume, key);
            }
        } else {
            registry.addWildcard(key);
        }
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    protected void addMessageBodyWriter(MessageBodyWriter provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        Utils.injectProperties(this.rpf, providerClass, provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        SortedKey<MessageBodyWriter> key = new SortedKey<MessageBodyWriter>(MessageBodyWriter.class, provider, providerClass, priority, isBuiltin);
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                registry.add(consume, key);
            }
        } else {
            registry.add("*/*", key);
        }
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getMessageBodyReadersForWrite() {
        if (this.messageBodyReaders == null) {
            return new MediaTypeMap<SortedKey<MessageBodyReader>>();
        }
        if (this.lockSnapshots || this.attachedMessageBodyReaders) {
            return new MediaTypeMap<SortedKey<MessageBodyReader>>(this.messageBodyReaders);
        }
        return this.messageBodyReaders;
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getMessageBodyWritersForWrite() {
        if (this.messageBodyWriters == null) {
            return new MediaTypeMap<SortedKey<MessageBodyWriter>>();
        }
        if (this.lockSnapshots || this.attachedMessageBodyWriters) {
            return new MediaTypeMap<SortedKey<MessageBodyWriter>>(this.messageBodyWriters);
        }
        return this.messageBodyWriters;
    }

    protected JaxrsInterceptorRegistry<ReaderInterceptor> getReaderInterceptorRegistryForWrite() {
        if (this.readerInterceptorRegistry == null) {
            return new ReaderInterceptorRegistryImpl(this.rpf);
        }
        if (this.lockSnapshots || this.attachedReaderInterceptors) {
            return this.readerInterceptorRegistry.clone((ResteasyProviderFactory)this.rpf);
        }
        return this.readerInterceptorRegistry;
    }

    protected JaxrsInterceptorRegistry<WriterInterceptor> getWriterInterceptorRegistryForWrite() {
        if (this.writerInterceptorRegistry == null) {
            return new WriterInterceptorRegistryImpl(this.rpf);
        }
        if (this.lockSnapshots || this.attachedWriterInterceptors) {
            return this.writerInterceptorRegistry.clone((ResteasyProviderFactory)this.rpf);
        }
        return this.writerInterceptorRegistry;
    }

    protected Set<DynamicFeature> getDynamicFeaturesForWrite() {
        if (this.dynamicFeatures == null) {
            return new HashSet<DynamicFeature>();
        }
        if (this.lockSnapshots || this.attachedFeatures) {
            return new HashSet<DynamicFeature>(this.dynamicFeatures);
        }
        return this.dynamicFeatures;
    }

    public MediaTypeMap<SortedKey<MessageBodyReader>> getMessageBodyReaders() {
        return this.messageBodyReaders;
    }

    public MediaTypeMap<SortedKey<MessageBodyWriter>> getMessageBodyWriters() {
        return this.messageBodyWriters;
    }

    public JaxrsInterceptorRegistry<ReaderInterceptor> getReaderInterceptorRegistry() {
        return this.readerInterceptorRegistry;
    }

    public JaxrsInterceptorRegistry<WriterInterceptor> getWriterInterceptorRegistry() {
        return this.writerInterceptorRegistry;
    }

    public Set<DynamicFeature> getDynamicFeatures() {
        return this.dynamicFeatures;
    }

    public void lockSnapshots() {
        this.lockSnapshots = true;
        if (this.messageBodyReaders != null) {
            this.messageBodyReaders.lockSnapshots();
        }
        if (this.messageBodyWriters != null) {
            this.messageBodyWriters.lockSnapshots();
        }
    }

    public void addDynamicFeature(Class provider) {
        Set<DynamicFeature> registry = this.getDynamicFeaturesForWrite();
        registry.add((DynamicFeature)this.rpf.injectedInstance(provider));
        this.attachedFeatures = false;
        this.dynamicFeatures = registry;
    }

    public void addWriterInterceptor(Class provider, int priority) {
        JaxrsInterceptorRegistry<WriterInterceptor> registry = this.getWriterInterceptorRegistryForWrite();
        registry.registerClass(provider, priority);
        this.attachedWriterInterceptors = false;
        this.writerInterceptorRegistry = registry;
    }

    public void addReaderInterceptor(Class provider, int priority) {
        JaxrsInterceptorRegistry<ReaderInterceptor> registry = this.getReaderInterceptorRegistryForWrite();
        registry.registerClass(provider, priority);
        this.attachedReaderInterceptors = false;
        this.readerInterceptorRegistry = registry;
    }

    public void addWildcardMBR(SortedKey<MessageBodyReader> mbr) {
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        registry.addWildcard(mbr);
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    public void addSubtypeWildMBR(MediaType mediaType, SortedKey<MessageBodyReader> mbr) {
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        registry.addWildSubtype(mediaType, mbr);
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    public void addRegularMBR(MediaType mediaType, SortedKey<MessageBodyReader> mbr) {
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        registry.addRegular(mediaType, mbr);
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    public void addCompositeWildcardMBR(MediaType mediaType, SortedKey<MessageBodyReader> mbr, String baseSubtype) {
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        registry.addCompositeWild(mediaType, mbr, baseSubtype);
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    public void addWildcardCompositeMBR(MediaType mediaType, SortedKey<MessageBodyReader> mbr, String baseSubtype) {
        MediaTypeMap<SortedKey<MessageBodyReader>> registry = this.getMessageBodyReadersForWrite();
        registry.addWildComposite(mediaType, mbr, baseSubtype);
        this.attachedMessageBodyReaders = false;
        this.messageBodyReaders = registry;
    }

    public void addWildcardMBW(SortedKey<MessageBodyWriter> mbw) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        registry.addWildcard(mbw);
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }

    public void addRegularMBW(MediaType mediaType, SortedKey<MessageBodyWriter> mbw) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        registry.addRegular(mediaType, mbw);
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }

    public void addSubtypeWildMBW(MediaType mediaType, SortedKey<MessageBodyWriter> mbw) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        registry.addWildSubtype(mediaType, mbw);
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }

    public void addCompositeWildcardMBW(MediaType mediaType, SortedKey<MessageBodyWriter> mbw, String baseSubtype) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        registry.addCompositeWild(mediaType, mbw, baseSubtype);
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }

    public void addWildcardCompositeMBW(MediaType mediaType, SortedKey<MessageBodyWriter> mbw, String baseSubtype) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> registry = this.getMessageBodyWritersForWrite();
        registry.addWildComposite(mediaType, mbw, baseSubtype);
        this.attachedMessageBodyWriters = false;
        this.messageBodyWriters = registry;
    }
}

