/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    JDKSpecific() {
    }

    static String getApplicationProtocol(SSLEngine sslEngine) {
        return sslEngine.getApplicationProtocol();
    }

    static String getHandshakeApplicationProtocol(SSLEngine sslEngine) {
        return sslEngine.getHandshakeApplicationProtocol();
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sslEngine, BiFunction<SSLEngine, List<String>, String> selector) {
        sslEngine.setHandshakeApplicationProtocolSelector(selector);
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine sslEngine) {
        return sslEngine.getHandshakeApplicationProtocolSelector();
    }

    static String[] getApplicationProtocols(SSLParameters parameters) {
        return parameters.getApplicationProtocols();
    }

    static void setApplicationProtocols(SSLParameters parameters, String[] protocols) {
        parameters.setApplicationProtocols(protocols);
    }

    static SSLParameters setSSLParameters(SSLParameters original) {
        SSLParameters params = new SSLParameters();
        params.setProtocols(original.getProtocols());
        params.setCipherSuites(original.getCipherSuites());
        params.setUseCipherSuitesOrder(original.getUseCipherSuitesOrder());
        params.setServerNames(original.getServerNames());
        params.setSNIMatchers(original.getSNIMatchers());
        params.setAlgorithmConstraints(original.getAlgorithmConstraints());
        params.setEndpointIdentificationAlgorithm(original.getEndpointIdentificationAlgorithm());
        if (original.getWantClientAuth()) {
            params.setWantClientAuth(original.getWantClientAuth());
        } else if (original.getNeedClientAuth()) {
            params.setNeedClientAuth(original.getNeedClientAuth());
        }
        params.setEnableRetransmissions(original.getEnableRetransmissions());
        params.setApplicationProtocols(original.getApplicationProtocols());
        params.setMaximumPacketSize(original.getMaximumPacketSize());
        return params;
    }

    static String getApplicationProtocol(SSLSocket socket) {
        return socket.getApplicationProtocol();
    }

    static String getHandshakeApplicationProtocol(SSLSocket socket) {
        return socket.getHandshakeApplicationProtocol();
    }

    static void setHandshakeApplicationProtocolSelector(SSLSocket socket, BiFunction<SSLSocket, List<String>, String> selector) {
        socket.setHandshakeApplicationProtocolSelector(selector);
    }

    static BiFunction<SSLSocket, List<String>, String> getHandshakeApplicationProtocolSelector(SSLSocket socket) {
        return socket.getHandshakeApplicationProtocolSelector();
    }
}

