/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

public abstract class HandlerBase {
    private static final ThreadLocal<Counter> inHandler = ThreadLocal.withInitial(() -> new Counter());

    protected static void enter() {
        ++HandlerBase.inHandler.get().count;
    }

    public static boolean inHandler() {
        return HandlerBase.inHandler.get().count > 0;
    }

    protected static void leave() {
        --HandlerBase.inHandler.get().count;
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }
    }
}

