/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.discovery.ServiceURL;

public interface ServicesQueue
extends AutoCloseable {
    public void await() throws InterruptedException;

    public void await(long var1, TimeUnit var3) throws InterruptedException;

    public boolean isReady();

    default public URI poll() {
        ServiceURL serviceURL = this.pollService();
        return serviceURL == null ? null : serviceURL.getLocationURI();
    }

    default public URI take() throws InterruptedException {
        ServiceURL serviceURL = this.takeService();
        return serviceURL == null ? null : serviceURL.getLocationURI();
    }

    public ServiceURL pollService();

    public ServiceURL takeService() throws InterruptedException;

    public ServiceURL takeService(long var1, TimeUnit var3) throws InterruptedException;

    public boolean isFinished();

    @Override
    public void close();

    @NotNull
    public List<Throwable> getProblems();

    default public ServicesQueue withTimeout(long time, TimeUnit unit) {
        Assert.checkNotNullParam("unit", unit);
        final long timeoutNanos = unit.toNanos(time);
        final long start = System.nanoTime();
        return new ServicesQueue(){

            @Override
            public void await() throws InterruptedException {
                long elapsed = System.nanoTime() - start;
                if (elapsed < timeoutNanos) {
                    ServicesQueue.this.await(elapsed, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public void await(long time, TimeUnit unit) throws InterruptedException {
                long elapsed = System.nanoTime() - start;
                long callerNs = unit.toNanos(time);
                ServicesQueue.this.await(Math.min(timeoutNanos - elapsed, callerNs), TimeUnit.NANOSECONDS);
            }

            @Override
            public boolean isReady() {
                return ServicesQueue.this.isReady();
            }

            @Override
            public URI poll() {
                return ServicesQueue.this.poll();
            }

            @Override
            public URI take() throws InterruptedException {
                this.await();
                return this.poll();
            }

            @Override
            public ServiceURL pollService() {
                return ServicesQueue.this.pollService();
            }

            @Override
            public ServiceURL takeService() throws InterruptedException {
                this.await();
                return this.pollService();
            }

            @Override
            public ServiceURL takeService(long timeout, TimeUnit timeUnit) throws InterruptedException {
                this.await(timeout, timeUnit);
                return this.pollService();
            }

            @Override
            public boolean isFinished() {
                return ServicesQueue.this.isFinished() || !this.isReady() && timeoutNanos > System.nanoTime() - start;
            }

            @Override
            public void close() {
                ServicesQueue.this.close();
            }

            @Override
            @NotNull
            public List<Throwable> getProblems() {
                return ServicesQueue.this.getProblems();
            }
        };
    }
}

