/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store._private;

import java.io.IOException;
import java.security.KeyStore;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=2009, max=2009), @ValidIdRange(min=9500, max=9528), @ValidIdRange(min=11006, max=11006), @ValidIdRange(min=20000, max=20999)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=2009, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=9500, value="External storage key under alias \"%s\" has to be a SecretKey")
    public CredentialStoreException wrongTypeOfExternalStorageKey(String var1);

    @Message(id=9504, value="Cannot acquire a credential from the credential store")
    public CredentialStoreException cannotAcquireCredentialFromStore(@Cause Throwable var1);

    @Message(id=9505, value="Cannot perform operation '%s': Credential store is set non modifiable")
    public CredentialStoreException nonModifiableCredentialStore(String var1);

    @Message(id=9507, value="Invalid protection parameter given: %s")
    public CredentialStoreException invalidProtectionParameter(CredentialStore.ProtectionParameter var1);

    @Message(id=9508, value="Cannot write credential to store")
    public CredentialStoreException cannotWriteCredentialToStore(@Cause Throwable var1);

    @Message(id=9509, value="Unsupported credential type %s")
    public UnsupportedCredentialTypeException unsupportedCredentialType(Class<?> var1);

    @Message(id=9510, value="Invalid credential store keystore entry %s: expected %s")
    public CredentialStoreException invalidCredentialStoreEntryType(Class<? extends KeyStore.Entry> var1, Class<? extends KeyStore.Entry> var2);

    @Message(id=9511, value="Unable to read credential %s from store")
    public CredentialStoreException unableToReadCredentialTypeFromStore(Class<? extends Credential> var1);

    @Message(id=9512, value="Unable to remove credential from store")
    public CredentialStoreException cannotRemoveCredentialFromStore(@Cause Throwable var1);

    @Message(id=9513, value="Unable to flush credential store to storage")
    public CredentialStoreException cannotFlushCredentialStore(@Cause Throwable var1);

    @Message(id=9514, value="Unable to initialize credential store")
    public CredentialStoreException cannotInitializeCredentialStore(@Cause Throwable var1);

    @Message(id=9515, value="Ignored unrecognized key store entry \"%s\"")
    @LogMessage(level=Logger.Level.DEBUG)
    public void logIgnoredUnrecognizedKeyStoreEntry(String var1);

    @Message(id=9516, value="Failed to read a credential entry from the key store")
    @LogMessage(level=Logger.Level.WARN)
    public void logFailedToReadKeyFromKeyStore(@Cause Throwable var1);

    @Message(id=9517, value="This credential store type requires a store-wide protection parameter")
    public CredentialStoreException protectionParameterRequired();

    @Message(id=9518, value="Automatic storage creation for the Credential Store is disabled \"%s\"")
    public CredentialStoreException automaticStorageCreationDisabled(String var1);

    @Message(id=9519, value="Unexpected credential store external storage file version \"%s\"")
    public IOException unexpectedFileVersion(String var1);

    @Message(id=9520, value="Unrecognized entry type \"%s\"")
    public IOException unrecognizedEntryType(String var1);

    @Message(id=9521, value="Internal encryption problem while reading \"%s\"")
    public IOException internalEncryptionProblem(@Cause Exception var1, String var2);

    @Message(id=9522, value="\"%s\" is not a block based algorithm")
    public CredentialStoreException algorithmNotBlockBased(String var1);

    @Message(id=9523, value="Algorithm \"%s\" does not use an initialization vector (IV)")
    public CredentialStoreException algorithmNotIV(String var1);

    @Message(id=9524, value="The actual number of bytes read %d is different from the expected number of bytes %d to be read")
    public IOException readBytesMismatch(int var1, int var2);

    @Message(id=9525, value="location and externalPath initial attributes are the same. [location=%s, externalPath=%s]")
    public CredentialStoreException locationAndExternalPathAreIdentical(String var1, String var2);

    @Message(id=9526, value="Unable to initialize credential store as attribute %s is unsupported in %s")
    public CredentialStoreException unsupportedAttribute(String var1, List<String> var2);

    @Message(id=9528, value="The externalPath attribute for key store type %s is missing.")
    public CredentialStoreException externalPathMissing(String var1);

    @Message(id=11006, value="External storage key under alias \"%s\" does not exist")
    public CredentialStoreException externalStorageKeyDoesNotExist(String var1);

    @Message(id=20000, value="The credential store file %s does not exist or cannot be accessed.")
    public CredentialStoreException credentialStoreFileDoesNotExist(String var1);

    @Message(id=20001, value="The credential store has not been initialised.")
    public CredentialStoreException storeNotInitialised();

    @Message(id=20002, value="The required initialisation attribute '%s' has not been specified.")
    public CredentialStoreException missingInitialisationAttribute(String var1);

    @Message(id=20003, value="Invalid CredentialStore property '%s'.")
    public CredentialStoreException invalidCredentialStoreProperty(String var1);

    @Message(id=20004, value="Can not load SecretKey for '%s'.")
    public CredentialStoreException canNotLoadSecretKey(String var1, @Cause Throwable var2);
}

