/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.common.parser.ModelXMLElementWriter;
import org.wildfly.extension.picketlink.idm.Namespace;

public class IDMSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final Map<String, ModelXMLElementWriter> writers = new HashMap<String, ModelXMLElementWriter>();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode subsystemNode = context.getModelNode();
        if (subsystemNode.isDefined()) {
            List identityManagement = subsystemNode.asList();
            for (ModelNode modelNode : identityManagement) {
                writers.get(ModelElement.PARTITION_MANAGER.getName()).write(writer, modelNode);
            }
        }
        writer.writeEndElement();
    }

    private static void registerWriter(ModelElement element, ModelElement keyAttribute) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, keyAttribute.getName(), writers));
    }

    private static void registerWriter(ModelElement element) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, writers));
    }

    private static void registerWriter(ModelElement element, ModelElement keyAttribute, XMLElement parent) {
        writers.put(element.getName(), new ModelXMLElementWriter(element, keyAttribute.getName(), parent, writers));
    }

    static {
        IDMSubsystemWriter.registerWriter(ModelElement.PARTITION_MANAGER, ModelElement.COMMON_NAME);
        IDMSubsystemWriter.registerWriter(ModelElement.IDENTITY_CONFIGURATION, ModelElement.COMMON_NAME);
        IDMSubsystemWriter.registerWriter(ModelElement.JPA_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.FILE_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE_MAPPING, ModelElement.COMMON_NAME, XMLElement.LDAP_MAPPINGS);
        IDMSubsystemWriter.registerWriter(ModelElement.LDAP_STORE_ATTRIBUTE);
        IDMSubsystemWriter.registerWriter(ModelElement.SUPPORTED_TYPES);
        IDMSubsystemWriter.registerWriter(ModelElement.SUPPORTED_TYPE, ModelElement.COMMON_NAME);
        IDMSubsystemWriter.registerWriter(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, ModelElement.COMMON_NAME, XMLElement.IDENTITY_STORE_CREDENTIAL_HANDLERS);
    }
}

