/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.DriverService;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JdbcDriverAdd
extends AbstractAddStepHandler {
    static final JdbcDriverAdd INSTANCE = new JdbcDriverAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String driverName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        for (SimpleAttributeDefinition attribute : Constants.JDBC_DRIVER_ATTRIBUTES) {
            if (attribute.getName().equals("driver-name")) continue;
            attribute.validateAndSet(operation, model);
        }
        model.get(Constants.DRIVER_NAME.getName()).set(driverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Class<CommonDataSource> dsCls;
        Module module;
        ModuleIdentifier moduleId;
        ModelNode address = operation.require("address");
        String driverName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        if (operation.get(Constants.DRIVER_NAME.getName()).isDefined() && !driverName.equals(operation.get(Constants.DRIVER_NAME.getName()).asString())) {
            throw ConnectorLogger.ROOT_LOGGER.driverNameAndResourceNameNotEquals(operation.get(Constants.DRIVER_NAME.getName()).asString(), driverName);
        }
        String moduleName = Constants.DRIVER_MODULE_NAME.resolveModelAttribute(context, model).asString();
        Integer majorVersion = model.hasDefined(Constants.DRIVER_MAJOR_VERSION.getName()) ? Integer.valueOf(Constants.DRIVER_MAJOR_VERSION.resolveModelAttribute(context, model).asInt()) : null;
        Integer minorVersion = model.hasDefined(Constants.DRIVER_MINOR_VERSION.getName()) ? Integer.valueOf(Constants.DRIVER_MINOR_VERSION.resolveModelAttribute(context, model).asInt()) : null;
        String driverClassName = model.hasDefined(Constants.DRIVER_CLASS_NAME.getName()) ? Constants.DRIVER_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        String dataSourceClassName = model.hasDefined(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()) ? Constants.DRIVER_DATASOURCE_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        String xaDataSourceClassName = model.hasDefined(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()) ? Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        ServiceTarget target = context.getServiceTarget();
        String slot = model.hasDefined(Constants.MODULE_SLOT.getName()) ? Constants.MODULE_SLOT.resolveModelAttribute(context, model).asString() : null;
        try {
            moduleId = ModuleIdentifier.create((String)moduleName, (String)slot);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleNotFoundException e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.missingDependencyInModuleDriver(moduleName, e.getMessage()), (Throwable)e);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToLoadModuleDriver(moduleName), (Throwable)e);
        }
        if (dataSourceClassName != null) {
            try {
                dsCls = module.getClassLoader().loadClass(dataSourceClassName).asSubclass(DataSource.class);
            }
            catch (ClassNotFoundException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.failedToLoadDataSourceClass(dataSourceClassName, e);
            }
            catch (ClassCastException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.notAValidDataSourceClass(dataSourceClassName, DataSource.class.getName());
            }
            JdbcDriverAdd.checkDSCls(dsCls, DataSource.class);
        }
        if (xaDataSourceClassName != null) {
            try {
                dsCls = module.getClassLoader().loadClass(xaDataSourceClassName).asSubclass(XADataSource.class);
            }
            catch (ClassNotFoundException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.failedToLoadDataSourceClass(xaDataSourceClassName, e);
            }
            catch (ClassCastException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.notAValidDataSourceClass(dataSourceClassName, DataSource.class.getName());
            }
            JdbcDriverAdd.checkDSCls(dsCls, XADataSource.class);
        }
        if (driverClassName == null) {
            ServiceLoader serviceLoader = module.loadService(Driver.class);
            boolean driverLoaded = false;
            if (serviceLoader != null) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
                try {
                    Iterator iterator = serviceLoader.iterator();
                    if (iterator.hasNext()) {
                        Driver driver = (Driver)iterator.next();
                        JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
                        driverLoaded = true;
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
            if (!driverLoaded) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotFindDriverClassName(driverName);
            }
        } else {
            try {
                Class<Driver> driverClass = module.getClassLoader().loadClass(driverClassName).asSubclass(Driver.class);
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                Driver driver = null;
                try {
                    Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
                    Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                    driver = constructor.newInstance(new Object[0]);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
                JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
            }
            catch (Exception e) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.cannotInstantiateDriverClass(driverClassName));
            }
        }
    }

    public static void startDriverServices(ServiceTarget target, ModuleIdentifier moduleId, Driver driver, String driverName, Integer majorVersion, Integer minorVersion, String dataSourceClassName, String xaDataSourceClassName) throws IllegalStateException {
        int majorVer = driver.getMajorVersion();
        int minorVer = driver.getMinorVersion();
        if (majorVersion != null && majorVersion != majorVer || minorVersion != null && minorVersion != minorVer) {
            throw ConnectorLogger.ROOT_LOGGER.driverVersionMismatch();
        }
        boolean compliant = driver.jdbcCompliant();
        if (compliant) {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        } else {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingNonCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        }
        InstalledDriver driverMetadata = new InstalledDriver(driverName, moduleId, driver.getClass().getName(), dataSourceClassName, xaDataSourceClassName, majorVer, minorVer, compliant);
        DriverService driverService = new DriverService(driverMetadata, driver);
        ServiceBuilder builder = target.addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    static <T> void checkDSCls(Class<? extends T> dsCls, Class<T> t) throws OperationFailedException {
        if (Modifier.isInterface(dsCls.getModifiers()) || Modifier.isAbstract(dsCls.getModifiers())) {
            throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.notAValidDataSourceClass(dsCls.getName(), t.getName());
        }
    }
}

