/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.subsystems.resourceadapters.ConfigPropertiesService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ConfigPropertyAdd
extends AbstractAddStepHandler {
    public static final ConfigPropertyAdd INSTANCE = new ConfigPropertyAdd();

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        Constants.CONFIG_PROPERTY_VALUE.validateAndSet(operation, modelNode);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel) throws OperationFailedException {
        String configPropertyValue = Constants.CONFIG_PROPERTY_VALUE.resolveModelAttribute(context, recoveryEnvModel).asString();
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String archiveName = path.getElement(path.size() - 2).getValue();
        String configPropertyName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, configPropertyName});
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName});
        ServiceTarget serviceTarget = context.getServiceTarget();
        ConfigPropertiesService service = new ConfigPropertiesService(configPropertyName, configPropertyValue);
        serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector()).install();
    }
}

