/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementServiceConfigurator;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;

public class InfinispanSessionManagementServiceConfigurator
extends SessionManagementServiceConfigurator<InfinispanSessionManagementConfiguration<DeploymentUnit>>
implements InfinispanSessionManagementConfiguration<DeploymentUnit> {
    private volatile String containerName;
    private volatile String cacheName;

    public InfinispanSessionManagementServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanSessionManagementResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanSessionManagementResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return super.configure(context, model);
    }

    @Override
    public DistributableSessionManagementProvider<InfinispanSessionManagementConfiguration<DeploymentUnit>> get() {
        return new InfinispanSessionManagementProvider(this, this.getRouteLocatorServiceConfiguratorFactory());
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

