/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.io.IoCallback;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NonceManager;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class LogoutHandler
implements HttpHandler {
    public static final String PATH = "/logout";
    public static final String CONTEXT = "org.jboss.as.console.logout.context";
    private static final String EXIT = "org.jboss.as.console.logout.exit";
    private static final String HIT_ESCAPE = "HIT THE ESCAPE KEY";
    private static final String BASIC = "BASIC";
    private static final String DIGEST = "DIGEST";
    private static final String MECHANISM = "mechanism";
    private final DigestAuthenticationMechanism digestMechanism;
    private final DigestAuthenticationMechanism fakeRealmdigestMechanism;
    private final BasicAuthenticationMechanism basicMechanism;
    private final BasicAuthenticationMechanism fakeRealmBasicMechanism;

    public LogoutHandler(String realmName) {
        List<DigestAlgorithm> digestAlgorithms = Collections.singletonList(DigestAlgorithm.MD5);
        List digestQops = Collections.emptyList();
        this.digestMechanism = new DigestAuthenticationMechanism(digestAlgorithms, digestQops, realmName, "/management", (NonceManager)new SimpleNonceManager());
        this.fakeRealmdigestMechanism = new DigestAuthenticationMechanism(digestAlgorithms, digestQops, HIT_ESCAPE, "/management", (NonceManager)new SimpleNonceManager());
        this.basicMechanism = new BasicAuthenticationMechanism(realmName);
        this.fakeRealmBasicMechanism = new BasicAuthenticationMechanism(HIT_ESCAPE);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean exit;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String referrer = responseHeaders.getFirst(Headers.REFERER);
        String protocol = exchange.getRequestScheme();
        Object host = null;
        if (referrer != null) {
            try {
                URI uri = new URI(referrer);
                protocol = uri.getScheme();
                host = uri.getHost() + this.portPortion(protocol, uri.getPort());
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if (host == null && (host = requestHeaders.getFirst(Headers.HOST)) == null) {
            exchange.setStatusCode(500);
            return;
        }
        String userAgent = requestHeaders.getFirst(Headers.USER_AGENT);
        boolean opera = userAgent != null && userAgent.contains("Opera");
        boolean win = !opera && userAgent != null && (userAgent.contains("MSIE") || userAgent.contains("Trident"));
        String rawQuery = exchange.getQueryString();
        boolean bl = exit = rawQuery != null && rawQuery.contains(EXIT);
        if (win) {
            responseHeaders.add(Headers.LOCATION, protocol + "://" + (String)host + "/");
            exchange.setStatusCode(307);
        } else {
            String authorization = requestHeaders.getFirst(Headers.AUTHORIZATION);
            boolean digest = true;
            Map parameters = exchange.getQueryParameters();
            if (parameters.containsKey(MECHANISM)) {
                boolean bl2 = digest = !BASIC.equals(((Deque)parameters.get(MECHANISM)).getFirst());
            }
            if (authorization != null && authorization.length() > BASIC.length() && BASIC.equalsIgnoreCase(authorization.substring(0, BASIC.length()))) {
                digest = false;
                ByteBuffer decode = FlexBase64.decode((String)authorization.substring(6));
                authorization = new String(decode.array(), decode.arrayOffset(), decode.limit(), StandardCharsets.UTF_8);
            }
            if (authorization == null || !authorization.contains("enter-login-here")) {
                if (!exit) {
                    responseHeaders.add(Headers.LOCATION, protocol + "://enter-login-here:blah@" + (String)host + "/logout?org.jboss.as.console.logout.exit&mechanism=" + (digest ? DIGEST : BASIC));
                    exchange.setStatusCode(307);
                    return;
                }
                this.mechanism(opera, digest).sendChallenge(exchange, null);
                String reply = "<html><script type='text/javascript'>window.location=\"" + protocol + "://" + (String)host + "/\";</script></html>";
                exchange.setStatusCode(401);
                exchange.getResponseSender().send(reply, IoCallback.END_EXCHANGE);
                return;
            }
            responseHeaders.add(Headers.LOCATION, protocol + "://" + (String)host + "/");
            exchange.setStatusCode(307);
        }
    }

    private AuthenticationMechanism mechanism(boolean opera, boolean digest) {
        if (digest) {
            return opera ? this.fakeRealmdigestMechanism : this.digestMechanism;
        }
        return opera ? this.fakeRealmBasicMechanism : this.basicMechanism;
    }

    private String portPortion(String scheme, int port) {
        if (port == -1 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            return "";
        }
        return ":" + String.valueOf(port);
    }
}

