/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jgroups.JChannel;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.MethodCall;
import org.jgroups.jmx.AdditionalJmxObjects;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class JChannelProbeHandler
implements DiagnosticsHandler.ProbeHandler {
    protected final JChannel ch;
    protected final Log log;

    public JChannelProbeHandler(JChannel ch) {
        this.ch = ch;
        this.log = LogFactory.getLog(ch.getClass());
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : keys) {
            int right;
            int index;
            if (key.startsWith("jmx")) {
                this.handleJmx(map, key);
                continue;
            }
            if (key.startsWith("reset-stats")) {
                this.resetAllStats();
                continue;
            }
            if (key.startsWith("ops")) {
                this.listOperations(map, key);
                continue;
            }
            if (key.startsWith("invoke") || key.startsWith("op")) {
                int index2 = key.indexOf(61);
                if (index2 == -1) continue;
                try {
                    this.handleOperation(map, key.substring(index2 + 1));
                }
                catch (Throwable throwable) {
                    this.log.error(Util.getMessage("OperationInvocationFailure"), key.substring(index2 + 1), throwable);
                }
                continue;
            }
            if (key.startsWith("threads")) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                boolean cpu_supported = bean.isThreadCpuTimeSupported();
                boolean contention_supported = bean.isThreadContentionMonitoringSupported();
                int max_name = 0;
                long[] ids = bean.getAllThreadIds();
                ArrayList<ThreadEntry> entries = new ArrayList<ThreadEntry>(ids.length);
                for (long id : ids) {
                    double user_time;
                    double cpu_time;
                    ThreadInfo info = bean.getThreadInfo(id);
                    if (info == null) continue;
                    String thread_name = info.getThreadName();
                    max_name = Math.max(max_name, thread_name.length());
                    Thread.State state = info.getThreadState();
                    long blocked = info.getBlockedCount();
                    long blocked_time = contention_supported ? info.getBlockedTime() : -1L;
                    long waited = info.getWaitedCount();
                    long waited_time = contention_supported ? info.getWaitedTime() : -1L;
                    double d = cpu_time = cpu_supported ? (double)bean.getThreadCpuTime(id) : -1.0;
                    if (cpu_time > 0.0) {
                        cpu_time /= 1000000.0;
                    }
                    double d2 = user_time = cpu_supported ? (double)bean.getThreadUserTime(id) : -1.0;
                    if (user_time > 0.0) {
                        user_time /= 1000000.0;
                    }
                    ThreadEntry entry = new ThreadEntry(state, thread_name, blocked, waited, blocked_time, waited_time, cpu_time, user_time);
                    entries.add(entry);
                }
                int index3 = key.indexOf(61);
                if (index3 >= 0) {
                    Comparator<ThreadEntry> comp = Comparator.comparing(e -> e.thread_name);
                    String val = key.substring(index3 + 1);
                    if (val.startsWith("state")) {
                        comp = Comparator.comparing(e -> e.state);
                    } else if (val.startsWith("cpu")) {
                        comp = Comparator.comparing(e -> e.cpu_time).reversed();
                    } else if (val.startsWith("user")) {
                        comp = Comparator.comparing(e -> e.user_time).reversed();
                    } else if (val.startsWith("block")) {
                        comp = Comparator.comparing(e -> e.blocks).reversed();
                    } else if (val.startsWith("btime")) {
                        comp = Comparator.comparing(e -> e.block_time).reversed();
                    } else if (val.startsWith("wait")) {
                        comp = Comparator.comparing(e -> e.waits).reversed();
                    } else if (val.startsWith("wtime")) {
                        comp = Comparator.comparing(e -> e.wait_time).reversed();
                    }
                    entries.sort(comp);
                }
                index3 = key.indexOf(61, index3 + 1);
                int limit = 0;
                if (index3 >= 0) {
                    String val = key.substring(index3 + 1);
                    limit = Integer.parseInt(val);
                }
                max_name = Math.min(max_name, 50) + 1;
                String title = "\n[%s]   \t%-" + max_name + "s: %10s %10s %6s %9s %10s %10s\n";
                String line = "[%s]\t%-" + max_name + "s: %,8.0f %,8.0f %,10d %,9.0f %,10d %,10.0f\n";
                StringBuilder sb = new StringBuilder(String.format(title, "state", "thread-name", "cpu (ms)", "user (ms)", "block", "btime (ms)", "wait", "wtime (ms)"));
                Stream stream = entries.stream();
                if (limit > 0) {
                    stream = stream.limit(limit);
                }
                stream.forEach(e -> sb.append(e.print(line)));
                map.put(key, sb.toString());
                continue;
            }
            if (key.equals("enable-cpu")) {
                map.put(key, JChannelProbeHandler.enable(1, true));
                continue;
            }
            if (key.startsWith("enable-cont")) {
                map.put(key, JChannelProbeHandler.enable(2, true));
                continue;
            }
            if (key.equals("disable-cpu")) {
                map.put(key, JChannelProbeHandler.enable(1, false));
                continue;
            }
            if (key.startsWith("disable-cont")) {
                map.put(key, JChannelProbeHandler.enable(2, false));
            }
            String protocol = (index = key.indexOf(46)) == -1 ? key : key.substring(0, index);
            Object prot = this.ch.getProtocolStack().findProtocol(protocol);
            if (prot == null) continue;
            String tmp = key.substring(index + 1);
            int left = tmp.indexOf(91);
            int n = right = left != -1 ? tmp.indexOf(93, left) : -1;
            if (left != -1 && right != -1) {
                try {
                    return this.handleProbe("op=" + key);
                }
                catch (Throwable throwable) {
                    this.log.error(Util.getMessage("OperationInvocationFailure"), key.substring(index + 1), throwable);
                    continue;
                }
            }
            return this.handleProbe("jmx=" + key);
        }
        return map;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"reset-stats", "jmx", "op=<operation>[<args>]", "ops", "threads[=<filter>[=<limit>]]", "enable-cpu", "enable-contention", "disable-cpu", "disable-contention"};
    }

    protected static String enable(int type, boolean flag) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        boolean supported = false;
        if (type == 1) {
            supported = bean.isThreadCpuTimeSupported();
            if (supported) {
                bean.setThreadCpuTimeEnabled(flag);
            }
        } else if (type == 2 && (supported = bean.isThreadContentionMonitoringSupported())) {
            bean.setThreadContentionMonitoringEnabled(flag);
        }
        String tmp = type == 1 ? "CPU" : "contention";
        return String.format("%s monitoring supported: %b, %s monitoring enabled: %b", tmp, supported, tmp, supported && flag);
    }

    protected JChannel resetAllStats() {
        List<Protocol> prots = this.ch.getProtocolStack().getProtocols();
        prots.forEach(Protocol::resetStatistics);
        return this.ch.resetStats();
    }

    protected Map<String, Map<String, Object>> dumpAttrsAllProtocols() {
        return this.ch.dumpStats();
    }

    protected Map<String, Map<String, Object>> dumpAttrsSelectedProtocol(String protocol_name, List<String> attrs) {
        return this.ch.dumpStats(protocol_name, attrs);
    }

    protected void handleJmx(Map<String, String> map, String input) {
        int index = input.indexOf(61);
        if (index == -1) {
            Map<String, Map<String, Object>> tmp_stats = this.dumpAttrsAllProtocols();
            JChannelProbeHandler.convert(tmp_stats, map);
            return;
        }
        String protocol_name = input.substring(index + 1);
        if ((index = protocol_name.indexOf(46)) == -1) {
            Map<String, Map<String, Object>> tmp_stats = this.dumpAttrsSelectedProtocol(protocol_name, null);
            JChannelProbeHandler.convert(tmp_stats, map);
            return;
        }
        String rest = protocol_name;
        protocol_name = protocol_name.substring(0, index);
        String attrs = rest.substring(index + 1);
        List<String> list = Util.parseStringList(attrs, ",");
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String tmp = it.next();
            index = tmp.indexOf(61);
            if (index <= -1) continue;
            it.remove();
            String attrname = tmp.substring(0, index);
            String attrvalue = tmp.substring(index + 1);
            this.handleAttrWrite(protocol_name, attrname, attrvalue);
        }
        if (!list.isEmpty()) {
            Map<String, Map<String, Object>> tmp_stats = this.dumpAttrsSelectedProtocol(protocol_name, list);
            JChannelProbeHandler.convert(tmp_stats, map);
        }
    }

    protected void listOperations(Map<String, String> map, String key) {
        if (!key.contains("=")) {
            map.put("ops", this.listAllOperations());
            return;
        }
        String p = key.substring(key.indexOf("=") + 1).trim();
        try {
            Class<? extends Protocol> cl = Util.loadProtocolClass(p, this.getClass());
            StringBuilder sb = new StringBuilder();
            JChannelProbeHandler.listAllOperations(sb, cl);
            map.put("ops", sb.toString());
        }
        catch (Exception e) {
            this.log.warn("%s: protocol %s not found", this.ch.getAddress(), p);
        }
    }

    protected String listAllOperations() {
        StringBuilder sb = new StringBuilder();
        for (Protocol p : this.ch.getProtocolStack().getProtocols()) {
            JChannelProbeHandler.listAllOperations(sb, p.getClass());
        }
        return sb.toString();
    }

    protected static void listAllOperations(StringBuilder sb, Class<? extends Protocol> cl) {
        Method[] methods;
        sb.append(cl.getSimpleName()).append(":\n");
        for (Method m : methods = Util.getAllDeclaredMethodsWithAnnotations(cl, ManagedOperation.class)) {
            sb.append("  ").append(JChannelProbeHandler.methodToString(m)).append("\n");
        }
    }

    protected static String methodToString(Method m) {
        StringBuilder sb = new StringBuilder(m.getName());
        sb.append('(');
        StringJoiner sj = new StringJoiner(",");
        for (Class<?> parameterType : m.getParameterTypes()) {
            sj.add(parameterType.getTypeName());
        }
        sb.append(sj);
        sb.append(')');
        return sb.toString();
    }

    protected void handleOperation(Map<String, String> map, String operation) throws Exception {
        Object retval;
        Method method;
        int index = operation.indexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("operation " + operation + " is missing the protocol name");
        }
        String prot_name = operation.substring(0, index);
        Protocol prot = null;
        try {
            Class<? extends Protocol> cl = Util.loadProtocolClass(prot_name, this.getClass());
            prot = (Protocol)this.ch.getProtocolStack().findProtocol(cl);
        }
        catch (Exception cl) {
            // empty catch block
        }
        if (prot == null) {
            prot = (Protocol)this.ch.getProtocolStack().findProtocol(prot_name);
        }
        if (prot == null) {
            this.log.error("protocol %s not found", prot_name);
            return;
        }
        int args_index = operation.indexOf(91);
        String method_name = args_index != -1 ? operation.substring(index + 1, args_index).trim() : operation.substring(index + 1).trim();
        String[] args = null;
        if (args_index != -1) {
            int end_index = operation.indexOf(93);
            if (end_index == -1) {
                throw new IllegalArgumentException("] not found");
            }
            List<String> str_args = Util.parseCommaDelimitedStrings(operation.substring(args_index + 1, end_index));
            Object[] strings = str_args.toArray();
            args = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                args[i] = (String)strings[i];
            }
        }
        if ((method = this.findMethod(prot, method_name, args)) == null) {
            throw new IllegalArgumentException(String.format("method %s not found in %s", method_name, prot.getName()));
        }
        MethodCall call = new MethodCall(method, new Object[0]);
        Object[] converted_args = null;
        if (args != null) {
            converted_args = new Object[args.length];
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                converted_args[i] = Util.convert(args[i], types[i]);
            }
        }
        if ((retval = call.invoke(prot, converted_args)) != null) {
            map.put(prot.getName() + "." + method_name, retval.toString());
        }
    }

    protected Method findMethod(Protocol prot, String method_name, String[] args) throws Exception {
        Object target = prot;
        Method method = MethodCall.findMethod(target.getClass(), method_name, args);
        if (method == null) {
            if (prot instanceof AdditionalJmxObjects) {
                for (Object obj : ((AdditionalJmxObjects)((Object)prot)).getJmxObjects()) {
                    method = MethodCall.findMethod(obj.getClass(), method_name, args);
                    if (method == null) continue;
                    target = obj;
                    break;
                }
            }
            if (method == null) {
                this.log.warn(Util.getMessage("MethodNotFound"), this.ch.getAddress(), target.getClass().getSimpleName(), method_name);
                return null;
            }
        }
        return method;
    }

    protected void handleAttrWrite(String protocol_name, String attr_name, String attr_value) {
        Object[] objs;
        Field field;
        Object target = this.ch.getProtocolStack().findProtocol(protocol_name);
        Field field2 = field = target != null ? Util.getField(target.getClass(), attr_name) : null;
        if (field == null && target instanceof AdditionalJmxObjects && (objs = ((AdditionalJmxObjects)target).getJmxObjects()) != null && objs.length > 0) {
            for (Object o : objs) {
                Field field3 = field = o != null ? Util.getField(o.getClass(), attr_name) : null;
                if (field == null) continue;
                target = o;
                break;
            }
        }
        if (field != null) {
            Object value = Util.convert(attr_value, field.getType());
            if (value != null) {
                if (target instanceof Protocol) {
                    ((Protocol)target).setValue(attr_name, value);
                } else {
                    Util.setField(field, target, value);
                }
            }
        } else {
            Object[] objs2;
            ResourceDMBean.Accessor setter = ResourceDMBean.findSetter(target, attr_name);
            if (setter == null && target instanceof AdditionalJmxObjects && (objs2 = ((AdditionalJmxObjects)target).getJmxObjects()) != null && objs2.length > 0) {
                for (Object o : objs2) {
                    ResourceDMBean.Accessor accessor = setter = o != null ? ResourceDMBean.findSetter(o, attr_name) : null;
                    if (setter != null) break;
                }
            }
            if (setter != null) {
                try {
                    Class<?> type = setter instanceof ResourceDMBean.FieldAccessor ? ((ResourceDMBean.FieldAccessor)setter).getField().getType() : (setter instanceof ResourceDMBean.MethodAccessor ? ((ResourceDMBean.MethodAccessor)setter).getMethod().getParameterTypes()[0] : null);
                    Object converted_value = Util.convert(attr_value, type);
                    setter.invoke(converted_value);
                }
                catch (Exception e) {
                    this.log.error("unable to invoke %s() on %s: %s", setter, protocol_name, e);
                }
            } else {
                this.log.warn(Util.getMessage("FieldNotFound"), attr_name, protocol_name);
                setter = new ResourceDMBean.NoopAccessor();
            }
        }
    }

    protected static void convert(Map<String, Map<String, Object>> in, Map<String, String> out) {
        if (in != null) {
            in.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> out.put((String)e.getKey(), ((Map)e.getValue()).toString()));
        }
    }

    protected static class ThreadEntry {
        protected final Thread.State state;
        protected final String thread_name;
        protected final long blocks;
        protected final long waits;
        protected final double block_time;
        protected final double wait_time;
        protected final double cpu_time;
        protected final double user_time;

        public ThreadEntry(Thread.State state, String thread_name, long blocks, long waits, double block_time, double wait_time, double cpu_time, double user_time) {
            this.state = state;
            this.thread_name = thread_name;
            this.blocks = blocks;
            this.waits = waits;
            this.block_time = block_time;
            this.wait_time = wait_time;
            this.cpu_time = cpu_time;
            this.user_time = user_time;
        }

        public String toString() {
            return String.format("[%s] %s: blocks=%d (%.2f ms) waits=%d (%.2f ms) sys=%.2f ms user=%.2f ms\n", new Object[]{this.state, this.thread_name, this.blocks, this.block_time, this.waits, this.wait_time, this.cpu_time, this.user_time});
        }

        protected String print(String format) {
            return String.format(format, new Object[]{this.state, this.thread_name, this.cpu_time, this.user_time, this.blocks, this.block_time, this.waits, this.wait_time});
        }
    }
}

