/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceAuthorization;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.ReadOperationDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadOperationNamesHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AliasStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ReadResourceDescriptionHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    private static final SimpleAttributeDefinition INHERITED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("inherited", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.TRUE)).build();
    private static final SimpleAttributeDefinition OPERATIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("operations", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    private static final SimpleAttributeDefinition NOTIFICATIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("notifications", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    private static final SimpleAttributeDefinition ACCESS_CONTROL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("access-control", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode(AccessControl.NONE.toString()))).setValidator(EnumValidator.create(AccessControl.class, (Enum[])new AccessControl[]{AccessControl.NONE, AccessControl.COMBINED_DESCRIPTIONS, AccessControl.TRIM_DESCRIPTONS}))).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-resource-description", ControllerResolver.getResolver("global")).setParameters(OPERATIONS, NOTIFICATIONS, INHERITED, GlobalOperationAttributes.RECURSIVE, GlobalOperationAttributes.RECURSIVE_DEPTH, GlobalOperationAttributes.PROXIES, GlobalOperationAttributes.INCLUDE_ALIASES, ACCESS_CONTROL, GlobalOperationAttributes.LOCALE).setReadOnly().setReplyType(ModelType.OBJECT).build();
    static final OperationStepHandler INSTANCE = new ReadResourceDescriptionHandler();
    private static final ModelNode PROXY_NO_SUCH_RESOURCE;

    private ReadResourceDescriptionHandler() {
        super(true);
    }

    ReadResourceDescriptionAccessControlContext getAccessControlContext() {
        return null;
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ReadResourceDescriptionAccessControlContext accessControlContext = this.getAccessControlContext() == null ? new ReadResourceDescriptionAccessControlContext(address, null) : this.getAccessControlContext();
        this.doExecute(context, operation, accessControlContext);
    }

    void doExecute(OperationContext context, ModelNode operation, ReadResourceDescriptionAccessControlContext accessControlContext) throws OperationFailedException {
        if (accessControlContext.parentAddresses == null) {
            this.doExecuteInternal(context, operation, accessControlContext);
        } else {
            try {
                this.doExecuteInternal(context, operation, accessControlContext);
            }
            catch (UnauthorizedException | Resource.NoSuchResourceException nsre) {
                context.getResult().set(new ModelNode());
            }
        }
    }

    private void doExecuteInternal(OperationContext context, ModelNode operation, ReadResourceDescriptionAccessControlContext accessControlContext) throws OperationFailedException {
        HashMap<PathElement, ModelNode> childResources;
        for (AttributeDefinition def : DEFINITION.getParameters()) {
            def.validateOperation(operation);
        }
        String opName = operation.require("operation").asString();
        PathAddress opAddr = PathAddress.pathAddress(operation.get("address"));
        boolean recursive = GlobalOperationHandlers.getRecursive(context, operation);
        boolean proxies = GlobalOperationAttributes.PROXIES.resolveModelAttribute(context, operation).asBoolean();
        boolean ops = OPERATIONS.resolveModelAttribute(context, operation).asBoolean();
        boolean nots = NOTIFICATIONS.resolveModelAttribute(context, operation).asBoolean();
        boolean aliases = GlobalOperationAttributes.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean();
        boolean inherited = INHERITED.resolveModelAttribute(context, operation).asBoolean();
        AccessControl accessControl = AccessControl.forName(ACCESS_CONTROL.resolveModelAttribute(context, operation).asString());
        ImmutableManagementResourceRegistration registry = this.getResourceRegistrationCheckForAlias(context, opAddr, accessControlContext);
        DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
        Locale locale = GlobalOperationHandlers.getLocale(context, operation);
        ModelNode nodeDescription = descriptionProvider.getModelDescription(locale);
        HashMap<String, ModelNode> operations = ops ? new HashMap<String, ModelNode>() : null;
        HashMap<String, ModelNode> notifications = nots ? new HashMap<String, ModelNode>() : null;
        HashMap<PathElement, ModelNode> hashMap = childResources = recursive ? new HashMap<PathElement, ModelNode>() : Collections.emptyMap();
        if (accessControl != AccessControl.NONE) {
            accessControlContext.initLocalResourceAddresses(context, opAddr);
        }
        ReadResourceDescriptionAssemblyHandler assemblyHandler = new ReadResourceDescriptionAssemblyHandler(nodeDescription, operations, notifications, childResources, accessControlContext, accessControl);
        context.addStep(assemblyHandler, OperationContext.Stage.MODEL, true);
        if (!aliases && nodeDescription.hasDefined("children")) {
            for (Property property : nodeDescription.get("children").asPropertyList()) {
                String key = property.getName();
                if (!this.isGlobalAlias(registry, property)) continue;
                nodeDescription.get("children").remove(key);
            }
        }
        if (ops) {
            for (Map.Entry<String, Object> entry : registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, inherited).entrySet()) {
                OperationEntry operationEntry = (OperationEntry)entry.getValue();
                if (!ReadOperationNamesHandler.isVisible(operationEntry, context)) continue;
                ReadOperationDescriptionHandler.DescribedOp describedOp = new ReadOperationDescriptionHandler.DescribedOp(operationEntry, locale);
                operations.put(entry.getKey(), describedOp.getDescription());
            }
        }
        if (nots) {
            for (Map.Entry<String, Object> entry : registry.getNotificationDescriptions(PathAddress.EMPTY_ADDRESS, inherited).entrySet()) {
                DescriptionProvider provider = ((NotificationEntry)entry.getValue()).getDescriptionProvider();
                notifications.put(entry.getKey(), provider.getModelDescription(locale));
            }
        }
        if (nodeDescription.hasDefined("attributes")) {
            for (String string : nodeDescription.require("attributes").keys()) {
                AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, string);
                AttributeAccess.AccessType accessType = access == null ? AttributeAccess.AccessType.READ_ONLY : access.getAccessType();
                AttributeAccess.Storage storage = access == null ? AttributeAccess.Storage.CONFIGURATION : access.getStorageType();
                ModelNode attrNode = nodeDescription.get(new String[]{"attributes", string});
                String displayedAccessType = context.getProcessType() == ProcessType.DOMAIN_SERVER && storage == AttributeAccess.Storage.CONFIGURATION ? AttributeAccess.AccessType.READ_ONLY.toString() : accessType.toString();
                attrNode.get("access-type").set(displayedAccessType);
                attrNode.get("storage").set(storage.toString());
                if (accessType != AttributeAccess.AccessType.READ_WRITE) continue;
                Set<AttributeAccess.Flag> flags = access.getFlags();
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
                    attrNode.get("restart-required").set("all-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)) {
                    attrNode.get("restart-required").set("resource-services");
                    continue;
                }
                if (flags.contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                    attrNode.get("restart-required").set("jvm");
                    continue;
                }
                attrNode.get("restart-required").set("no-services");
            }
        }
        if (accessControl != AccessControl.NONE) {
            accessControlContext.checkResourceAccess(context, registry, nodeDescription, operations);
        }
        if (recursive) {
            for (PathElement pathElement : registry.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                PathAddress relativeAddr = PathAddress.pathAddress(pathElement);
                ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                boolean readChild = true;
                if (childReg.isRemote() && !proxies) {
                    readChild = false;
                }
                if (childReg.isAlias() && !aliases) {
                    readChild = false;
                }
                if (readChild) {
                    PathAddress address;
                    ModelNode rrOp = operation.clone();
                    try {
                        address = PathAddress.pathAddress(opAddr, pathElement);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    rrOp.get("address").set(address.toModelNode());
                    GlobalOperationHandlers.setNextRecursive(context, operation, rrOp);
                    ModelNode rrRsp = new ModelNode();
                    childResources.put(pathElement, rrRsp);
                    OperationStepHandler handler = this.getRecursiveStepHandler(childReg, opName, accessControlContext, address);
                    context.addStep(rrRsp, rrOp, handler, OperationContext.Stage.MODEL, true);
                    nodeDescription.get(new String[]{"children", pathElement.getKey(), "model-description", pathElement.getValue()});
                    continue;
                }
                if (!childReg.isAlias() || aliases || !this.isSingletonResource(registry, pathElement.getKey()) || !nodeDescription.get("children").hasDefined(pathElement.getKey())) continue;
                nodeDescription.get("children").get(pathElement.getKey()).remove(pathElement.getValue());
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    for (ModelNode value : childResources.values()) {
                        if (!value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        break;
                    }
                }
            }
        });
    }

    private boolean isSingletonResource(ImmutableManagementResourceRegistration registry, String key) {
        return registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(key))) == null;
    }

    private boolean isGlobalAlias(ImmutableManagementResourceRegistration registry, Property child) {
        if (this.isSingletonResource(registry, child.getName())) {
            Set<PathElement> childrenPath = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
            boolean found = false;
            boolean alias = true;
            for (PathElement childPath : childrenPath) {
                if (!childPath.getKey().equals(child.getName())) continue;
                found = true;
                ImmutableManagementResourceRegistration squatterRegistration = registry.getSubModel(PathAddress.pathAddress(childPath));
                alias = alias && squatterRegistration != null && squatterRegistration.isAlias();
            }
            if (found && alias) {
                return true;
            }
            ImmutableManagementResourceRegistration squatterRegistration = registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(child.getName(), child.getValue().asString())));
            return squatterRegistration != null && squatterRegistration.isAlias();
        }
        String key = child.getName();
        ImmutableManagementResourceRegistration wildCardChildRegistration = registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(key)));
        boolean isAlias = wildCardChildRegistration.isAlias();
        Set<String> registredNames = registry.getChildNames(PathAddress.pathAddress(PathElement.pathElement(key)));
        if (registredNames != null && !registredNames.isEmpty() && isAlias) {
            for (String value : registredNames) {
                ImmutableManagementResourceRegistration childRegistration = registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(key, value)));
                if (isAlias = isAlias && childRegistration != null && childRegistration.isAlias()) continue;
                return false;
            }
        }
        return isAlias;
    }

    private OperationStepHandler getRecursiveStepHandler(ImmutableManagementResourceRegistration childReg, String opName, ReadResourceDescriptionAccessControlContext accessControlContext, PathAddress address) {
        OperationStepHandler overrideHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
        if (overrideHandler != null && (overrideHandler.getClass() == ReadResourceDescriptionHandler.class || overrideHandler.getClass() == AliasStepHandler.class)) {
            overrideHandler = null;
        }
        if (overrideHandler != null) {
            return new NestedReadResourceDescriptionHandler(overrideHandler);
        }
        return new NestedReadResourceDescriptionHandler(new ReadResourceDescriptionAccessControlContext(address, accessControlContext));
    }

    private ImmutableManagementResourceRegistration getResourceRegistrationCheckForAlias(OperationContext context, PathAddress opAddr, ReadResourceDescriptionAccessControlContext accessControlContext) {
        ImmutableManagementResourceRegistration root = context.getRootResourceRegistration();
        ImmutableManagementResourceRegistration registry = root.getSubModel(opAddr);
        AliasEntry aliasEntry = registry.getAliasEntry();
        if (aliasEntry == null) {
            return registry;
        }
        PathAddress realAddress = aliasEntry.convertToTargetAddress(opAddr, AliasEntry.AliasContext.create(opAddr, context));
        assert (!realAddress.equals(opAddr)) : "Alias was not translated";
        return root.getSubModel(realAddress);
    }

    static {
        ModelNode none = new ModelNode();
        none.get("no-such-resource").set("no$such$resource");
        none.protect();
        PROXY_NO_SUCH_RESOURCE = none;
    }

    public static enum AccessControl {
        NONE("none"),
        COMBINED_DESCRIPTIONS("combined-descriptions"),
        TRIM_DESCRIPTONS("trim-descriptions");

        private static final Map<String, AccessControl> MAP;
        private final String localName;

        public static AccessControl forName(String localName) {
            AccessControl value = localName != null ? MAP.get(localName.toLowerCase(Locale.ENGLISH)) : null;
            return value == null ? AccessControl.valueOf(localName.toUpperCase(Locale.ENGLISH)) : value;
        }

        private AccessControl(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }

        public ModelNode toModelNode() {
            return new ModelNode().set(this.toString());
        }

        static {
            HashMap<String, AccessControl> map = new HashMap<String, AccessControl>();
            for (AccessControl directoryGrouping : AccessControl.values()) {
                map.put(directoryGrouping.localName, directoryGrouping);
            }
            MAP = map;
        }
    }

    private class NestedReadResourceDescriptionHandler
    extends ReadResourceDescriptionHandler {
        final ReadResourceDescriptionAccessControlContext accessControlContext;
        final OperationStepHandler overrideStepHandler;

        NestedReadResourceDescriptionHandler(ReadResourceDescriptionAccessControlContext accessControlContext) {
            this.accessControlContext = accessControlContext;
            this.overrideStepHandler = null;
        }

        NestedReadResourceDescriptionHandler(OperationStepHandler overrideStepHandler) {
            this.accessControlContext = null;
            this.overrideStepHandler = overrideStepHandler;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.accessControlContext != null) {
                this.doExecute(context, operation, this.accessControlContext);
            } else {
                try {
                    this.overrideStepHandler.execute(context, operation);
                }
                catch (Resource.NoSuchResourceException e) {
                    context.getResult().set(PROXY_NO_SUCH_RESOURCE);
                }
                catch (UnauthorizedException e) {
                    context.getResult().set(new ModelNode());
                }
            }
        }
    }

    static final class ReadResourceDescriptionAccessControlContext {
        private final PathAddress opAddress;
        private final List<PathAddress> parentAddresses;
        private List<PathAddress> localResourceAddresses = null;
        private ModelNode defaultWildcardAccessControl;
        private Map<PathAddress, ModelNode> localResourceAccessControlResults = new HashMap<PathAddress, ModelNode>();

        ReadResourceDescriptionAccessControlContext(PathAddress opAddress, ReadResourceDescriptionAccessControlContext parent) {
            this.opAddress = opAddress;
            this.parentAddresses = parent != null ? parent.parentAddresses : null;
        }

        private void initLocalResourceAddresses(OperationContext context, PathAddress opAddress) {
            this.localResourceAddresses = this.getLocalResourceAddresses(context, opAddress);
        }

        private List<PathAddress> getLocalResourceAddresses(OperationContext context, PathAddress opAddr) {
            ArrayList<PathAddress> localResourceAddresses = null;
            if (this.parentAddresses == null) {
                if (opAddr.size() == 0) {
                    return Collections.singletonList(PathAddress.EMPTY_ADDRESS);
                }
                localResourceAddresses = new ArrayList();
                this.getAllActualResourceAddresses(context, localResourceAddresses, PathAddress.EMPTY_ADDRESS, opAddr);
            } else {
                localResourceAddresses = new ArrayList<PathAddress>();
                for (PathAddress pathAddress : this.parentAddresses) {
                    this.getAllActualResourceAddresses(context, localResourceAddresses, pathAddress, opAddr);
                }
            }
            return localResourceAddresses;
        }

        private void getAllActualResourceAddresses(OperationContext context, List<PathAddress> addresses, PathAddress currentAddress, PathAddress opAddress) {
            if (opAddress.size() == 0) {
                return;
            }
            int length = currentAddress.size();
            PathElement currentElement = opAddress.getElement(length);
            if (currentElement.isWildcard()) {
                Resource resource;
                try {
                    resource = context.readResourceFromRoot(currentAddress);
                }
                catch (UnauthorizedException e) {
                    ResourceAuthorization response = context.authorizeResource(false, false);
                    if (response.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() != AuthorizationResult.Decision.PERMIT) {
                        return;
                    }
                    resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                    for (Object element : currentAddress) {
                        resource = resource.getChild((PathElement)element);
                    }
                }
                ImmutableManagementResourceRegistration directRegistration = context.getRootResourceRegistration().getSubModel(currentAddress);
                Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, currentAddress, directRegistration, resource, currentElement.getKey());
                Set<String> childNames = childAddresses.get(currentElement.getKey());
                if (childNames != null && !childNames.isEmpty()) {
                    for (String name : childNames) {
                        PathAddress address = currentAddress.append(PathElement.pathElement(currentElement.getKey(), name));
                        if (!this.addParentResource(context, addresses, address)) continue;
                        if (address.size() == opAddress.size()) {
                            addresses.add(address);
                            continue;
                        }
                        this.getAllActualResourceAddresses(context, addresses, address, opAddress);
                    }
                } else {
                    PathAddress addr = currentAddress.append(opAddress.subAddress(currentAddress.size()));
                    addresses.add(addr);
                }
            } else {
                PathAddress address = currentAddress.append(currentElement);
                if (this.addParentResource(context, addresses, address)) {
                    if (address.size() == opAddress.size()) {
                        addresses.add(address);
                    } else {
                        this.getAllActualResourceAddresses(context, addresses, address, opAddress);
                    }
                }
            }
        }

        private boolean addParentResource(OperationContext context, List<PathAddress> addresses, PathAddress address) {
            try {
                context.readResourceFromRoot(address);
            }
            catch (Resource.NoSuchResourceException nsre) {
                return false;
            }
            catch (UnauthorizedException unauthorizedException) {
                // empty catch block
            }
            return true;
        }

        void checkResourceAccess(OperationContext context, ImmutableManagementResourceRegistration registration, ModelNode nodeDescription, Map<String, ModelNode> operations) {
            ModelNode defaultAccess = Util.createOperation(this.opAddress.size() > 0 && !this.opAddress.getLastElement().isWildcard() ? "check-default-resource-access" : "check-resource-access", this.opAddress);
            this.defaultWildcardAccessControl = new ModelNode();
            context.addStep(defaultAccess, new CheckResourceAccessHandler(registration.isRuntimeOnly(), true, this.defaultWildcardAccessControl, nodeDescription, operations), OperationContext.Stage.MODEL, true);
            for (PathAddress address : this.localResourceAddresses) {
                ModelNode op = Util.createOperation("check-resource-access", address);
                ModelNode resultHolder = new ModelNode();
                this.localResourceAccessControlResults.put(address, resultHolder);
                context.addStep(op, new CheckResourceAccessHandler(registration.isRuntimeOnly(), false, resultHolder, nodeDescription, operations), OperationContext.Stage.MODEL, true);
            }
        }
    }

    private static class ReadResourceDescriptionAssemblyHandler
    implements OperationStepHandler {
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;
        private final Map<String, ModelNode> notifications;
        private final Map<PathElement, ModelNode> childResources;
        private final ReadResourceDescriptionAccessControlContext accessControlContext;
        private final AccessControl accessControl;

        private ReadResourceDescriptionAssemblyHandler(ModelNode nodeDescription, Map<String, ModelNode> operations, Map<String, ModelNode> notifications, Map<PathElement, ModelNode> childResources, ReadResourceDescriptionAccessControlContext accessControlContext, AccessControl accessControl) {
            this.nodeDescription = nodeDescription;
            this.operations = operations;
            this.notifications = notifications;
            this.childResources = childResources;
            this.accessControlContext = accessControlContext;
            this.accessControl = accessControl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (Map.Entry<PathElement, ModelNode> entry : this.childResources.entrySet()) {
                PathElement element = entry.getKey();
                ModelNode value = entry.getValue();
                if (!value.has("failure-description")) {
                    ModelNode actualValue = value.get("result");
                    if (actualValue.equals(PROXY_NO_SUCH_RESOURCE)) {
                        this.nodeDescription.get("children").remove(element.getKey());
                        continue;
                    }
                    this.nodeDescription.get(new String[]{"children", element.getKey(), "model-description", element.getValue()}).set(actualValue);
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                break;
            }
            if (this.operations != null) {
                for (Map.Entry<Object, ModelNode> entry : this.operations.entrySet()) {
                    this.nodeDescription.get(new String[]{OPERATIONS.getName(), (String)entry.getKey()}).set(entry.getValue());
                }
            }
            if (this.notifications != null) {
                for (Map.Entry<Object, ModelNode> entry : this.notifications.entrySet()) {
                    this.nodeDescription.get(new String[]{NOTIFICATIONS.getName(), (String)entry.getKey()}).set(entry.getValue());
                }
            }
            if (this.accessControlContext.defaultWildcardAccessControl != null && this.accessControlContext.localResourceAccessControlResults != null) {
                ModelNode accessControl = new ModelNode();
                accessControl.setEmptyObject();
                if (this.accessControlContext.defaultWildcardAccessControl != null) {
                    accessControl.get("default").set(this.accessControlContext.defaultWildcardAccessControl);
                    ModelNode modelNode = this.accessControlContext.defaultWildcardAccessControl;
                } else {
                    ModelNode modelNode = new ModelNode();
                }
                if (this.accessControlContext.localResourceAccessControlResults != null) {
                    ModelNode exceptions = accessControl.get("exceptions");
                    exceptions.setEmptyObject();
                    for (Map.Entry<PathAddress, ModelNode> entry : this.accessControlContext.localResourceAccessControlResults.entrySet()) {
                        void var4_11;
                        if (!entry.getValue().isDefined() || entry.getValue().equals((ModelNode)var4_11)) continue;
                        ModelNode exceptionAddr = entry.getKey().toModelNode();
                        ModelNode exception = entry.getValue();
                        exception.get("address").set(exceptionAddr);
                        exceptions.get(exceptionAddr.asString()).set(entry.getValue());
                    }
                }
                this.nodeDescription.get(ACCESS_CONTROL.getName()).set(accessControl);
            }
            if (this.accessControl == AccessControl.TRIM_DESCRIPTONS) {
                this.nodeDescription.get("description").clear();
                if (this.nodeDescription.hasDefined("attributes")) {
                    this.nodeDescription.get("attributes").clear();
                }
                if (this.nodeDescription.hasDefined("operations")) {
                    this.nodeDescription.get("operations").clear();
                }
                if (this.nodeDescription.hasDefined("children")) {
                    for (String string : this.nodeDescription.get("children").keys()) {
                        ModelNode childNode = this.nodeDescription.get(new String[]{"children", string});
                        if (!childNode.isDefined()) continue;
                        childNode.remove("description");
                    }
                }
            }
            context.getResult().set(this.nodeDescription);
        }
    }

    static final class CheckResourceAccessHandler
    implements OperationStepHandler {
        static final OperationDefinition DEFAULT_DEFINITION = new SimpleOperationDefinitionBuilder("check-default-resource-access", NonResolvingResourceDescriptionResolver.INSTANCE).setPrivateEntry().build();
        static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("check-resource-access", NonResolvingResourceDescriptionResolver.INSTANCE).setPrivateEntry().build();
        private final boolean runtimeResource;
        private final boolean defaultSetting;
        private final ModelNode accessControlResult;
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;

        CheckResourceAccessHandler(boolean runtimeResource, boolean defaultSetting, ModelNode accessControlResult, ModelNode nodeDescription, Map<String, ModelNode> operations) {
            this.runtimeResource = runtimeResource;
            this.defaultSetting = defaultSetting;
            this.accessControlResult = accessControlResult;
            this.nodeDescription = nodeDescription;
            this.operations = operations;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = new ModelNode();
            boolean customDefaultCheck = operation.get("operation").asString().equals("check-default-resource-access");
            ResourceAuthorization authResp = context.authorizeResource(true, customDefaultCheck);
            if (authResp == null || authResp.getResourceResult(Action.ActionEffect.ADDRESS).getDecision() == AuthorizationResult.Decision.DENY) {
                if (this.defaultSetting && authResp != null) {
                    result.get(Action.ActionEffect.ADDRESS.toString()).set(false);
                }
            } else {
                this.addResourceAuthorizationResults(result, authResp);
                ModelNode attributes = new ModelNode();
                attributes.setEmptyObject();
                if (result.get("read").asBoolean()) {
                    if (this.nodeDescription.hasDefined("attributes")) {
                        for (Property attrProp : this.nodeDescription.require("attributes").asPropertyList()) {
                            ModelNode attributeResult = new ModelNode();
                            AttributeAccess.Storage storage = AttributeAccess.Storage.valueOf(attrProp.getValue().get("storage").asString().toUpperCase(Locale.ENGLISH));
                            this.addAttributeAuthorizationResults(attributeResult, attrProp.getName(), authResp, storage == AttributeAccess.Storage.RUNTIME);
                            if (!attributeResult.isDefined()) continue;
                            attributes.get(attrProp.getName()).set(attributeResult);
                        }
                    }
                    result.get("attributes").set(attributes);
                    if (this.operations != null) {
                        ModelNode ops = new ModelNode();
                        ops.setEmptyObject();
                        PathAddress currentAddress = context.getCurrentAddress();
                        for (Map.Entry<String, ModelNode> entry : this.operations.entrySet()) {
                            ModelNode operationToCheck = Util.createOperation(entry.getKey(), currentAddress);
                            ModelNode operationResult = new ModelNode();
                            this.addOperationAuthorizationResult(context, operationResult, operationToCheck, entry.getKey());
                            ops.get(entry.getKey()).set(operationResult);
                        }
                        result.get("operations").set(ops);
                    }
                }
            }
            this.accessControlResult.set(result);
        }

        private void addResourceAuthorizationResults(ModelNode result, ResourceAuthorization authResp) {
            if (this.runtimeResource) {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.READ_CONFIG);
                this.addResourceAuthorizationResult(result, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addResourceAuthorizationResult(ModelNode result, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authResult = authResp.getResourceResult(actionEffect);
            result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }

        private void addAttributeAuthorizationResults(ModelNode result, String attributeName, ResourceAuthorization authResp, boolean runtime) {
            if (runtime) {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_RUNTIME);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_RUNTIME);
            } else {
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.READ_CONFIG);
                this.addAttributeAuthorizationResult(result, attributeName, authResp, Action.ActionEffect.WRITE_CONFIG);
            }
        }

        private void addAttributeAuthorizationResult(ModelNode result, String attributeName, ResourceAuthorization authResp, Action.ActionEffect actionEffect) {
            AuthorizationResult authorizationResult = authResp.getAttributeResult(attributeName, actionEffect);
            if (authorizationResult != null) {
                result.get(actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME ? "read" : "write").set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
            }
        }

        private void addOperationAuthorizationResult(OperationContext context, ModelNode result, ModelNode operation, String operationName) {
            AuthorizationResult authorizationResult = context.authorizeOperation(operation);
            result.get("execute").set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }
    }
}

