/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.ContextualExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class ContextReferenceExecutor<C>
implements ContextualExecutor {
    private final C targetContext;
    private final ContextReference<C> reference;

    public ContextReferenceExecutor(C targetContext, ContextReference<C> reference) {
        this.targetContext = targetContext;
        this.reference = reference;
    }

    @Override
    public void execute(Runnable runner) {
        Object currentContext = this.reference.get();
        this.reference.accept(this.targetContext);
        try {
            runner.run();
        }
        finally {
            this.reference.accept(currentContext);
        }
    }

    @Override
    public <E extends Exception> void execute(ExceptionRunnable<E> runner) throws E {
        Object currentContext = this.reference.get();
        this.reference.accept(this.targetContext);
        try {
            runner.run();
        }
        finally {
            this.reference.accept(currentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Callable<T> caller) throws Exception {
        Object currentContext = this.reference.get();
        this.reference.accept(this.targetContext);
        try {
            T t = caller.call();
            return t;
        }
        finally {
            this.reference.accept(currentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Supplier<T> supplier) {
        Object currentContext = this.reference.get();
        this.reference.accept(this.targetContext);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.reference.accept(currentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(ExceptionSupplier<T, E> supplier) throws E {
        Object currentContext = this.reference.get();
        this.reference.accept(this.targetContext);
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            this.reference.accept(currentContext);
        }
    }
}

