/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.RecoveryScan;
import com.arjuna.ats.arjuna.recovery.ScanThread;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerStatus;
import com.arjuna.common.util.ConfigurationInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class RecoveryManager {
    public static final int INDIRECT_MANAGEMENT = 0;
    public static final int DIRECT_MANAGEMENT = 1;
    private RecoveryManagerImple _theImple = null;
    private int _mode;
    private static RecoveryManager _recoveryManager = null;
    private static boolean delayRecoveryManagerThread;

    public static final synchronized RecoveryManager manager() throws IllegalArgumentException {
        if (_recoveryManager == null) {
            return RecoveryManager.manager(0);
        }
        return _recoveryManager;
    }

    public static final synchronized RecoveryManager manager(int mode) throws IllegalArgumentException {
        if (_recoveryManager == null) {
            _recoveryManager = new RecoveryManager(mode);
        } else if (_recoveryManager.mode() != mode) {
            throw new IllegalArgumentException(tsLogger.i18NLogger.get_recovery_manager_already_started_in_different_mode(_recoveryManager.mode(), mode));
        }
        return _recoveryManager;
    }

    public static synchronized void delayRecoveryManagerThread() {
        delayRecoveryManagerThread = true;
    }

    public final void scan() {
        this.checkState();
        this._theImple.scan();
    }

    public final void scan(RecoveryScan callback) {
        this.checkState();
        ScanThread st = new ScanThread(this._theImple, callback);
        st.start();
    }

    public final void terminate() {
        this.terminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void terminate(boolean async) {
        this.checkState();
        Class<RecoveryManager> clazz = RecoveryManager.class;
        synchronized (RecoveryManager.class) {
            _recoveryManager = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this._theImple.stop(async);
            this._theImple = null;
            return;
        }
    }

    public final synchronized void initialize() {
        if (this._theImple == null) {
            this._theImple = this._mode == 0 && !delayRecoveryManagerThread ? new RecoveryManagerImple(true) : new RecoveryManagerImple(false);
        }
    }

    public void waitForTermination() {
        this.checkState();
        this._theImple.waitForTermination();
        this._theImple = null;
    }

    public void suspend(boolean async) {
        this.trySuspend(async);
    }

    public RecoveryManagerStatus trySuspend(boolean async) {
        this.checkState();
        PeriodicRecovery.Mode mode = this._theImple.trySuspendScan(async);
        switch (mode) {
            case ENABLED: {
                return RecoveryManagerStatus.ENABLED;
            }
            case SUSPENDED: {
                return RecoveryManagerStatus.SUSPENDED;
            }
            case TERMINATED: {
                return RecoveryManagerStatus.TERMINATED;
            }
        }
        throw new IllegalArgumentException("incompatible enum types");
    }

    public void resume() {
        this.checkState();
        this._theImple.resumeScan();
    }

    public void startRecoveryManagerThread() {
        this.checkState();
        this._theImple.start();
    }

    public final void addModule(RecoveryModule module) {
        this.checkState();
        this._theImple.addModule(module);
    }

    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        this.checkState();
        this._theImple.removeModule(module, waitOnScan);
    }

    public final void removeAllModules(boolean waitOnScan) {
        this.checkState();
        this._theImple.removeAllModules(waitOnScan);
    }

    public final Vector<RecoveryModule> getModules() {
        this.checkState();
        return this._theImple.getModules();
    }

    public final int mode() {
        return this._mode;
    }

    public static InetAddress getRecoveryManagerHost() throws UnknownHostException {
        String host = recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryAddress();
        return Utility.hostNameToInetAddress(host);
    }

    public static int getRecoveryManagerPort() {
        return recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryPort();
    }

    public static Socket getClientSocket() throws IOException {
        Socket socket = new Socket(RecoveryManager.getRecoveryManagerHost(), RecoveryManager.getRecoveryManagerPort());
        tsLogger.i18NLogger.info_recovery_RecoveryManager_4(socket.getInetAddress().getHostAddress(), Integer.toString(socket.getLocalPort()));
        return socket;
    }

    public static void main(String[] args) {
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-help") == 0) {
                System.out.println("Usage: com.arjuna.ats.arjuna.recovery.RecoveryManager [-help] [-test] [-version]");
                System.exit(0);
            }
            if (args[i].compareTo("-version") == 0) {
                System.out.println("Version " + ConfigurationInfo.getVersion());
                System.exit(0);
            }
            if (args[i].compareTo("-test") != 0) continue;
            testMode = true;
        }
        try {
            RecoveryManager manager = null;
            try {
                manager = RecoveryManager.manager();
            }
            catch (Throwable e) {
                if (testMode) {
                    System.err.println("Warning: got exception '" + e.toString() + "' on startup, will retry in 5 seconds in the hope it is transient.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("The retry attempt was interrupted. Exiting...");
                        throw new IllegalStateException(interruptedException);
                    }
                    manager = RecoveryManager.manager();
                }
                throw e;
            }
            if (testMode) {
                System.out.println("Ready");
            }
            manager.waitForTermination();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private RecoveryManager(int mode) {
        this._theImple = mode == 0 && !delayRecoveryManagerThread ? new RecoveryManagerImple(true) : new RecoveryManagerImple(false);
        this._mode = mode;
    }

    private final void checkState() {
        if (this._theImple == null) {
            throw new IllegalStateException(tsLogger.i18NLogger.get_recovery_manager_implementation_is_not_set());
        }
    }
}

