/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierObjectTable;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierResolver;
import org.jboss.as.ejb3.component.stateful.MarshallingConfigurationContext;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanClassTable;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanSerializabilityChecker;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.marshalling.jboss.DynamicExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class MarshallingConfigurationRepositoryServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
MarshallingConfigurationContext,
Supplier<MarshallingConfigurationRepository> {
    private final Module module;
    private final SupplierDependency<ModuleDeployment> deployment;

    public MarshallingConfigurationRepositoryServiceConfigurator(DeploymentUnit unit) {
        super(unit.getServiceName().append(new String[]{"marshalling"}));
        this.module = (Module)unit.getAttachment(Attachments.MODULE);
        this.deployment = new ServiceSupplierDependency(unit.getServiceName().append(ModuleDeployment.SERVICE_NAME));
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer repository = this.deployment.register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(repository, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public MarshallingConfigurationRepository get() {
        return new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this);
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public ModuleDeployment getDeployment() {
        return (ModuleDeployment)this.deployment.get();
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                Module module = context.getModule();
                ModuleDeployment deployment = context.getDeployment();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker(deployment));
                config.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
                config.setObjectTable((ObjectTable)new EJBClientContextIdentifierObjectTable());
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                Module module = context.getModule();
                ModuleDeployment deployment = context.getDeployment();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker(deployment));
                config.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
                config.setObjectResolver((ObjectResolver)new EJBClientContextIdentifierResolver());
                config.setObjectTable((ObjectTable)new DynamicExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

