/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.maps;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jctools.util.UnsafeAccess;

public class ConcurrentAutoTable
implements Serializable {
    private volatile CAT _cat = new CAT(null, 16, 0L);
    private static AtomicReferenceFieldUpdater<ConcurrentAutoTable, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentAutoTable.class, CAT.class, "_cat");

    public void add(long x) {
        this.add_if(x);
    }

    public void decrement() {
        this.add_if(-1L);
    }

    public void increment() {
        this.add_if(1L);
    }

    public void set(long x) {
        CAT newcat = new CAT(null, 4, x);
        while (!this.CAS_cat(this._cat, newcat)) {
        }
    }

    public long get() {
        return this._cat.sum();
    }

    public int intValue() {
        return (int)this._cat.sum();
    }

    public long longValue() {
        return this._cat.sum();
    }

    public long estimate_get() {
        return this._cat.estimate_sum();
    }

    public String toString() {
        return this._cat.toString();
    }

    public void print() {
        this._cat.print();
    }

    public int internal_size() {
        return this._cat._t.length;
    }

    private long add_if(long x) {
        return this._cat.add_if(x, ConcurrentAutoTable.hash(), this);
    }

    private boolean CAS_cat(CAT oldcat, CAT newcat) {
        return _catUpdater.compareAndSet(this, oldcat, newcat);
    }

    private static int hash() {
        int h = System.identityHashCode(Thread.currentThread());
        return h << 3;
    }

    private static class CAT
    implements Serializable {
        private static final int _Lbase = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
        private static final int _Lscale = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        private final CAT _next;
        private volatile long _fuzzy_sum_cache;
        private volatile long _fuzzy_time;
        private static final int MAX_SPIN = 1;
        private final long[] _t;

        private static long rawIndex(long[] ary, int i) {
            assert (i >= 0 && i < ary.length);
            return _Lbase + i * _Lscale;
        }

        private static boolean CAS(long[] A, int idx, long old, long nnn) {
            return UnsafeAccess.UNSAFE.compareAndSwapLong(A, CAT.rawIndex(A, idx), old, nnn);
        }

        CAT(CAT next, int sz, long init) {
            this._next = next;
            this._t = new long[sz];
            this._t[0] = init;
        }

        public long add_if(long x, int hash, ConcurrentAutoTable master) {
            long[] t = this._t;
            int idx = hash & t.length - 1;
            long old = t[idx];
            boolean ok = CAT.CAS(t, idx, old, old + x);
            if (ok) {
                return old;
            }
            int cnt = 0;
            while (!CAT.CAS(t, idx, old = t[idx], old + x)) {
                ++cnt;
            }
            if (cnt < 1) {
                return old;
            }
            if (t.length >= 0x100000) {
                return old;
            }
            if (master._cat != this) {
                return old;
            }
            CAT newcat = new CAT(this, t.length * 2, 0L);
            while (master._cat == this && !master.CAS_cat(this, newcat)) {
            }
            return old;
        }

        public long sum() {
            long[] t;
            long sum = this._next == null ? 0L : this._next.sum();
            for (long cnt : t = this._t) {
                sum += cnt;
            }
            return sum;
        }

        public long estimate_sum() {
            if (this._t.length <= 64) {
                return this.sum();
            }
            long millis = System.currentTimeMillis();
            if (this._fuzzy_time != millis) {
                this._fuzzy_sum_cache = this.sum();
                this._fuzzy_time = millis;
            }
            return this._fuzzy_sum_cache;
        }

        public String toString() {
            return Long.toString(this.sum());
        }

        public void print() {
            long[] t = this._t;
            System.out.print("[" + t[0]);
            for (int i = 1; i < t.length; ++i) {
                System.out.print("," + t[i]);
            }
            System.out.print("]");
            if (this._next != null) {
                this._next.print();
            }
        }
    }
}

