/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.SecurityDomainCheckHandler;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ActiveMQServerControlWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ActiveMQServerControlWriteHandler INSTANCE = new ActiveMQServerControlWriteHandler();

    private ActiveMQServerControlWriteHandler() {
        super(ServerDefinition.ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry, boolean registerRuntimeOnly) {
        for (AttributeDefinition attr : ServerDefinition.ATTRIBUTES) {
            if (!registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals(ServerDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
        if (attributeName.equals(ServerDefinition.SECURITY_DOMAIN.getName()) || attributeName.equals(ServerDefinition.ELYTRON_DOMAIN.getName())) {
            context.addStep((OperationStepHandler)SecurityDomainCheckHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName serviceName;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (attr.equals(ServerDefinition.CREDENTIAL_REFERENCE)) {
            return CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)newValue, (ModelNode)currentValue, (String)attributeName);
        }
        if (attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service == null) {
            return false;
        }
        if (service.getState() != ServiceController.State.UP) {
            return true;
        }
        if (!ActiveMQActivationService.isActiveMQServerActive(context, operation)) {
            return false;
        }
        this.applyOperationToActiveMQService(operation, attributeName, newValue, service);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry;
        ServiceController service;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (attr.equals(ServerDefinition.CREDENTIAL_REFERENCE)) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)attr, (OperationContext)context, (ModelNode)valueToRevert);
        }
        if (!attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES) && (service = (registry = context.getServiceRegistry(true)).getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))))) != null && service.getState() == ServiceController.State.UP) {
            this.applyOperationToActiveMQService(operation, attributeName, valueToRestore, service);
        }
    }

    private void applyOperationToActiveMQService(ModelNode operation, String attributeName, ModelNode newValue, ServiceController<?> activeMQServiceController) {
        block9: {
            ActiveMQServerControlImpl serverControl = ((ActiveMQServer)ActiveMQServer.class.cast(activeMQServiceController.getValue())).getActiveMQServerControl();
            if (serverControl == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
            }
            try {
                if (attributeName.equals(ServerDefinition.MESSAGE_COUNTER_SAMPLE_PERIOD.getName())) {
                    serverControl.setMessageCounterSamplePeriod(newValue.asLong());
                    break block9;
                }
                if (attributeName.equals(ServerDefinition.MESSAGE_COUNTER_MAX_DAY_HISTORY.getName())) {
                    serverControl.setMessageCounterMaxDayCount(newValue.asInt());
                    break block9;
                }
                if (attributeName.equals(ServerDefinition.STATISTICS_ENABLED.getName())) {
                    if (newValue.asBoolean()) {
                        serverControl.enableMessageCounters();
                    } else {
                        serverControl.disableMessageCounters();
                    }
                    break block9;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MessageCounterEnabledHandler
    implements OperationStepHandler {
        private MessageCounterEnabledHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode aliased = MessageCounterEnabledHandler.getAliasedOperation(operation);
            context.addStep(aliased, MessageCounterEnabledHandler.getHandlerForOperation(context, operation), OperationContext.Stage.MODEL, true);
        }

        private static ModelNode getAliasedOperation(ModelNode operation) {
            ModelNode aliased = operation.clone();
            aliased.get("name").set(ServerDefinition.STATISTICS_ENABLED.getName());
            return aliased;
        }

        private static OperationStepHandler getHandlerForOperation(OperationContext context, ModelNode operation) {
            ImmutableManagementResourceRegistration imrr = context.getResourceRegistration();
            return imrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, operation.get("operation").asString());
        }
    }
}

