/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.SharedStorePrimaryDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreSecondaryDefinition;

public class SharedStoreColocatedDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.REQUEST_BACKUP, HAAttributes.BACKUP_REQUEST_RETRIES, HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL, HAAttributes.MAX_BACKUPS, HAAttributes.BACKUP_PORT_OFFSET));
    public static final SharedStoreColocatedDefinition INSTANCE = new SharedStoreColocatedDefinition();

    private SharedStoreColocatedDefinition() {
        super(MessagingExtension.SHARED_STORE_COLOCATED_PATH, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation("ha-policy", false, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerAlias(MessagingExtension.CONFIGURATION_MASTER_PATH, SharedStoreColocatedDefinition.createAlias(resourceRegistration, MessagingExtension.CONFIGURATION_PRIMARY_PATH));
        resourceRegistration.registerAlias(MessagingExtension.CONFIGURATION_SLAVE_PATH, SharedStoreColocatedDefinition.createAlias(resourceRegistration, MessagingExtension.CONFIGURATION_SECONDARY_PATH));
    }

    private static AliasEntry createAlias(ManagementResourceRegistration resourceRegistration, final PathElement target) {
        return new AliasEntry(resourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{target}))){

            public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasEntry.AliasContext aliasContext) {
                return aliasAddress.getParent().append(new PathElement[]{target});
            }
        };
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(new PersistentResourceDefinition[]{SharedStorePrimaryDefinition.CONFIGURATION_INSTANCE, SharedStoreSecondaryDefinition.CONFIGURATION_INSTANCE}));
    }
}

