/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.io.Serializable;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.Base64;

public class JsonUtil {
    static String toJSON(Map<String, Object>[] messages) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Map<String, Object> message : messages) {
            array.add((JsonValue)JsonUtil.toJsonObject(message));
        }
        return array.build().toString();
    }

    private static JsonObject toJsonObject(Map<String, ?> map) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            JsonUtil.addToObject(String.valueOf(entry.getKey()), entry.getValue(), jsonObjectBuilder);
        }
        return jsonObjectBuilder.build();
    }

    private static void addToObject(String key, Object param, JsonObjectBuilder jsonObjectBuilder) {
        if (param instanceof Integer) {
            jsonObjectBuilder.add(key, ((Integer)param).intValue());
        } else if (param instanceof Long) {
            jsonObjectBuilder.add(key, ((Long)param).longValue());
        } else if (param instanceof Double) {
            jsonObjectBuilder.add(key, ((Double)param).doubleValue());
        } else if (param instanceof String) {
            jsonObjectBuilder.add(key, (String)param);
        } else if (param instanceof Boolean) {
            jsonObjectBuilder.add(key, ((Boolean)param).booleanValue());
        } else if (param instanceof Map) {
            JsonObject mapObject = JsonUtil.toJsonObject((Map)param);
            jsonObjectBuilder.add(key, (JsonValue)mapObject);
        } else if (param instanceof Short) {
            jsonObjectBuilder.add(key, (int)((Short)param).shortValue());
        } else if (param instanceof Byte) {
            jsonObjectBuilder.add(key, (int)((Byte)param).shortValue());
        } else if (param instanceof Number) {
            jsonObjectBuilder.add(key, ((Number)param).doubleValue());
        } else if (param instanceof SimpleString) {
            jsonObjectBuilder.add(key, param.toString());
        } else if (param == null) {
            jsonObjectBuilder.addNull(key);
        } else if (param instanceof byte[]) {
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder((byte[])param);
            jsonObjectBuilder.add(key, byteArrayObject);
        } else if (param instanceof Object[]) {
            JsonArrayBuilder objectArrayBuilder = Json.createArrayBuilder();
            for (Object parameter : (Object[])param) {
                JsonUtil.addToArray(parameter, objectArrayBuilder);
            }
            jsonObjectBuilder.add(key, objectArrayBuilder);
        } else {
            jsonObjectBuilder.add(key, param.toString());
        }
    }

    private static void addToArray(Object param, JsonArrayBuilder jsonArrayBuilder) {
        if (param instanceof Integer) {
            jsonArrayBuilder.add(((Integer)param).intValue());
        } else if (param instanceof Long) {
            jsonArrayBuilder.add(((Long)param).longValue());
        } else if (param instanceof Double) {
            jsonArrayBuilder.add(((Double)param).doubleValue());
        } else if (param instanceof String) {
            jsonArrayBuilder.add((String)param);
        } else if (param instanceof Boolean) {
            jsonArrayBuilder.add(((Boolean)param).booleanValue());
        } else if (param instanceof Map) {
            JsonObject mapObject = JsonUtil.toJsonObject((Map)param);
            jsonArrayBuilder.add((JsonValue)mapObject);
        } else if (param instanceof Short) {
            jsonArrayBuilder.add((int)((Short)param).shortValue());
        } else if (param instanceof Byte) {
            jsonArrayBuilder.add((int)((Byte)param).shortValue());
        } else if (param instanceof Number) {
            jsonArrayBuilder.add(((Number)param).doubleValue());
        } else if (param == null) {
            jsonArrayBuilder.addNull();
        } else if (param instanceof byte[]) {
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder((byte[])param);
            jsonArrayBuilder.add(byteArrayObject);
        } else if (param instanceof CompositeData[]) {
            JsonArrayBuilder innerJsonArray = Json.createArrayBuilder();
            for (CompositeData data : (CompositeData[])param) {
                String s = Base64.encodeObject((Serializable)((CompositeDataSupport)data));
                innerJsonArray.add(s);
            }
            JsonObjectBuilder jsonObject = Json.createObjectBuilder();
            jsonObject.add(CompositeData.class.getName(), innerJsonArray);
            jsonArrayBuilder.add(jsonObject);
        } else if (param instanceof Object[]) {
            JsonArrayBuilder objectArrayBuilder = Json.createArrayBuilder();
            for (Object parameter : (Object[])param) {
                JsonUtil.addToArray(parameter, objectArrayBuilder);
            }
            jsonArrayBuilder.add(objectArrayBuilder);
        } else {
            jsonArrayBuilder.add(param.toString());
        }
    }

    private static JsonArrayBuilder toJsonArrayBuilder(byte[] byteArray) {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (byteArray != null) {
            for (int i = 0; i < byteArray.length; ++i) {
                jsonArrayBuilder.add((int)Byte.valueOf(byteArray[i]).shortValue());
            }
        }
        return jsonArrayBuilder;
    }
}

