/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.health.HealthContextService;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;

public class MicroProfileHealthContextService
implements Service {
    private final Supplier<MicroProfileHealthReporter> healthReporter;
    private Supplier<HealthContextService> healthContextService;

    static void install(OperationContext context) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileHealthSubsystemDefinition.HTTP_CONTEXT_SERVICE);
        Supplier healthContextService = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.extension.health.http-context", HealthContextService.class));
        Supplier healthReporter = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.extension.microprofile.health.reporter", MicroProfileHealthReporter.class));
        serviceBuilder.setInstance((Service)new MicroProfileHealthContextService(healthContextService, healthReporter)).install();
    }

    private MicroProfileHealthContextService(Supplier<HealthContextService> healthContextService, Supplier<MicroProfileHealthReporter> healthReporter) {
        this.healthContextService = healthContextService;
        this.healthReporter = healthReporter;
    }

    public void start(StartContext context) {
        this.healthContextService.get().setOverrideableHealthHandler((HttpHandler)new HealthCheckHandler(this.healthReporter.get()));
    }

    public void stop(StopContext context) {
        this.healthContextService.get().setOverrideableHealthHandler(null);
    }

    private class HealthCheckHandler
    implements HttpHandler {
        private final MicroProfileHealthReporter healthReporter;
        public static final String HEALTH = "/health";
        public static final String HEALTH_LIVE = "/health/live";
        public static final String HEALTH_READY = "/health/ready";
        public static final String HEALTH_STARTED = "/health/started";

        public HealthCheckHandler(MicroProfileHealthReporter healthReporter) {
            this.healthReporter = healthReporter;
        }

        public void handleRequest(HttpServerExchange exchange) {
            SmallRyeHealth health;
            if (HEALTH.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getHealth();
            } else if (HEALTH_LIVE.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getLiveness();
            } else if (HEALTH_READY.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getReadiness();
            } else if (HEALTH_STARTED.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getStartup();
            } else {
                exchange.setStatusCode(404);
                return;
            }
            exchange.setStatusCode(health.isDown() ? 503 : 200).getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(health.getPayload().toString());
        }
    }
}

