/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.annotations;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.annotations.Emitter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;

@Qualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
@Experimental(value="smallrye-only")
public @interface EmitterFactoryFor {
    public Class<?> value();

    public static final class Literal
    extends AnnotationLiteral<EmitterFactoryFor>
    implements EmitterFactoryFor {
        private final Class<?> value;
        public static EmitterFactoryFor EMITTER = Literal.of(org.eclipse.microprofile.reactive.messaging.Emitter.class);
        public static EmitterFactoryFor MUTINY_EMITTER = Literal.of(MutinyEmitter.class);
        public static EmitterFactoryFor LEGACY_EMITTER = Literal.of(Emitter.class);

        public static EmitterFactoryFor of(Class<?> value) {
            return new Literal(value);
        }

        private Literal(Class<?> value) {
            this.value = value;
        }

        @Override
        public Class<?> value() {
            return this.value;
        }
    }
}

