/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ReactiveMessagingConfigSource
implements ConfigSource {
    private static final String NAME = ReactiveMessagingConfigSource.class.getName();
    private static final Map<String, String> PROPERTIES;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public ReactiveMessagingConfigSource() {
        this.properties.putAll(PROPERTIES);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return NAME;
    }

    public int getOrdinal() {
        return Integer.MAX_VALUE;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public static void addProperties(Config config, Map<String, String> properties) {
        for (ConfigSource source : config.getConfigSources()) {
            if (!source.getName().equals(NAME) || !(source instanceof ReactiveMessagingConfigSource)) continue;
            ((ReactiveMessagingConfigSource)source).properties.putAll(properties);
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mp.messaging.connector.smallrye-kafka.tracing-enabled", "false");
        map.put("smallrye-messaging-strict-binding", "true");
        PROPERTIES = Collections.unmodifiableMap(map);
    }
}

