/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.util.Objects;
import org.wildfly.security.key.RawPrivateKey;

class RawDSAPrivateKey
extends RawPrivateKey
implements DSAPrivateKey,
PrivateKey {
    private static final long serialVersionUID = 4399699674813282148L;
    private final BigInteger x;
    private final DSAParams params;

    RawDSAPrivateKey(DSAPrivateKey original) {
        super(original);
        this.x = original.getX();
        this.params = original.getParams();
    }

    RawDSAPrivateKey(Key key) {
        this((DSAPrivateKey)key);
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DSAParams getParams() {
        return this.params;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof DSAPrivateKey && this.isEqual((DSAPrivateKey)key);
    }

    boolean isEqual(DSAPrivateKey key) {
        return super.isEqual(key) && Objects.equals(this.x, key.getX()) && Objects.equals(this.params, key.getParams());
    }
}

