/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;

public class AMQPBrokerConnectionChannelHandler
extends ChannelDuplexHandler {
    private final ChannelGroup group;
    private final ProtonHandler handler;
    private final ClientConnectionLifeCycleListener listener;
    private final Executor listenerExecutor;
    private boolean active = true;

    protected AMQPBrokerConnectionChannelHandler(ChannelGroup group, ProtonHandler handler, ClientConnectionLifeCycleListener listener, Executor executor) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
        this.listenerExecutor = executor;
    }

    protected static Object channelId(Channel channel) {
        return channel.id();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.group.add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        AMQPBrokerConnectionChannelHandler aMQPBrokerConnectionChannelHandler = this;
        synchronized (aMQPBrokerConnectionChannelHandler) {
            if (this.active) {
                this.listenerExecutor.execute(() -> this.listener.connectionDestroyed(AMQPBrokerConnectionChannelHandler.channelId(ctx.channel())));
                super.channelInactive(ctx);
                this.active = false;
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        try {
            this.handler.inputBuffer(buffer);
        }
        finally {
            buffer.release();
        }
    }
}

