/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.utils;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class CancellablePublisher<T>
implements Publisher<T> {
    private final Publisher<T> source;
    private final AtomicBoolean subscribed = new AtomicBoolean();

    public CancellablePublisher(Publisher<T> delegate) {
        this.source = delegate;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        if (this.subscribed.compareAndSet(false, true)) {
            this.source.subscribe(subscriber);
        } else {
            Subscriptions.fail(subscriber, (Throwable)new IllegalStateException("Multicast not supported"));
        }
    }

    public void cancelIfNotSubscribed() {
        if (this.subscribed.compareAndSet(false, true)) {
            this.source.subscribe((Subscriber)new Subscriptions.CancelledSubscriber());
        }
    }
}

