/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jboss.marshalling.MarshallingConfiguration;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;

public class SimpleMarshallingConfigurationRepository
implements MarshallingConfigurationRepository {
    private final MarshallingConfiguration[] configurations;
    private final int currentVersion;

    public <C, E extends Enum<E>> SimpleMarshallingConfigurationRepository(Class<E> enumClass, E current, C context) {
        this(current.ordinal() + 1, SimpleMarshallingConfigurationRepository.createConfigurations(enumClass, context));
    }

    private static <C, E extends Enum<E>> MarshallingConfiguration[] createConfigurations(Class<E> enumClass, C context) {
        List<Function> values = Arrays.asList((Function[])enumClass.getEnumConstants());
        MarshallingConfiguration[] configurations = new MarshallingConfiguration[values.size()];
        for (int i = 0; i < configurations.length; ++i) {
            configurations[i] = (MarshallingConfiguration)values.get(i).apply(context);
        }
        return configurations;
    }

    public SimpleMarshallingConfigurationRepository(MarshallingConfiguration ... configurations) {
        this(configurations.length, configurations);
    }

    private SimpleMarshallingConfigurationRepository(int currentVersion, MarshallingConfiguration ... configurations) {
        this.currentVersion = currentVersion;
        this.configurations = configurations;
    }

    @Override
    public int getCurrentMarshallingVersion() {
        return this.currentVersion;
    }

    @Override
    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.configurations[version - 1];
    }
}

