/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment.injection;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import org.wildfly.extension.messaging.activemq.deployment.injection.JMSInfo;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public abstract class AbstractJMSContext
implements Serializable {
    private final Map<String, JMSContext> contexts = new ConcurrentHashMap<String, JMSContext>();

    JMSContext getContext(String injectionPointId, JMSInfo info, ConnectionFactory connectionFactory) {
        return this.contexts.computeIfAbsent(injectionPointId, key -> this.createContext(info, connectionFactory));
    }

    private JMSContext createContext(JMSInfo info, ConnectionFactory connectionFactory) {
        JMSContext context;
        MessagingLogger.ROOT_LOGGER.debugf("Create JMSContext from %s - %s", info, connectionFactory);
        int sessionMode = info.getSessionMode();
        String userName = info.getUserName();
        if (userName == null) {
            context = connectionFactory.createContext(sessionMode);
        } else {
            String password = info.getPassword();
            context = connectionFactory.createContext(userName, password, sessionMode);
        }
        return context;
    }

    void cleanUp() {
        MessagingLogger.ROOT_LOGGER.debugf("Clean up JMSContext created from %s", this);
        for (JMSContext jmsContext : this.contexts.values()) {
            jmsContext.close();
        }
        this.contexts.clear();
    }
}

