/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.Arrays;
import java.util.Collections;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;

public class CascadeRemovalLifecycleListener
implements LifecycleListener {
    private final Iterable<ServiceController<?>> controllers;

    public CascadeRemovalLifecycleListener(ServiceController<?> controller) {
        this.controllers = Collections.singleton(controller);
    }

    public CascadeRemovalLifecycleListener(ServiceController<?> ... controllers) {
        this.controllers = Arrays.asList(controllers);
    }

    public CascadeRemovalLifecycleListener(Iterable<ServiceController<?>> controllers) {
        this.controllers = controllers;
    }

    public void handleEvent(ServiceController<?> source, LifecycleEvent event) {
        if (event == LifecycleEvent.REMOVED) {
            for (ServiceController<?> controller : this.controllers) {
                controller.setMode(ServiceController.Mode.REMOVE);
            }
            source.removeListener((LifecycleListener)this);
        }
    }
}

