/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.search.exception.SearchException;

public class MappingDefinitionRegistry<I, O> {
    private static final String GLOBAL_DEFINITION = "GLOBAL_DEFINITION";
    private final Map<String, O> definitions = new HashMap<String, O>();
    private final Map<String, String> definitionPoints = new HashMap<String, String>();
    private final Function<I, O> definitionInterpreter;
    private final Function<String, SearchException> duplicateDefinitionReporter;

    public MappingDefinitionRegistry(Function<I, O> definitionInterpreter, Function<String, SearchException> duplicateDefinitionReporter) {
        this.definitionInterpreter = definitionInterpreter;
        this.duplicateDefinitionReporter = duplicateDefinitionReporter;
    }

    public void registerGlobal(String name, I definition) {
        this.register(name, definition, GLOBAL_DEFINITION);
    }

    public void registerFromAnnotation(String name, I definition, XAnnotatedElement annotatedElement) {
        this.register(name, definition, this.buildAnnotationDefinitionPoint(annotatedElement));
    }

    public Map<String, O> getAll() {
        return Collections.unmodifiableMap(this.definitions);
    }

    private void register(String name, I definition, String definitionPoint) {
        if (this.definitionPoints.containsKey(name)) {
            if (!this.definitionPoints.get(name).equals(definitionPoint)) {
                throw this.duplicateDefinitionReporter.apply(name);
            }
        } else {
            this.definitions.put(name, this.definitionInterpreter.apply(definition));
            this.definitionPoints.put(name, definitionPoint);
        }
    }

    private String buildAnnotationDefinitionPoint(XAnnotatedElement annotatedElement) {
        if (annotatedElement instanceof XClass) {
            return ((XClass)annotatedElement).getName();
        }
        if (annotatedElement instanceof XMember) {
            XMember member = (XMember)annotatedElement;
            return member.getType().getName() + '.' + member.getName();
        }
        if (annotatedElement instanceof XPackage) {
            return ((XPackage)annotatedElement).getName();
        }
        throw new SearchException("Unknown XAnnotatedElement: " + annotatedElement);
    }
}

