/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.impl.MutableAnalyzerRegistry;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.ParseContext;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TypeMetadata {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String COMPONENT_PATH_SEPARATOR = ".";
    private final IndexedTypeIdentifier type;
    private final float boost;
    private final Discriminator discriminator;
    private final XMember discriminatorGetter;
    private final BoostStrategy classBoostStrategy;
    private final Set<PropertyMetadata> propertyMetadata;
    private final Set<DocumentFieldMetadata> documentFieldMetadata;
    private final Map<String, DocumentFieldMetadata> documentFieldNameToFieldMetadata;
    private final Map<String, BridgeDefinedField> bridgeDefinedFieldNameToFieldMetadata;
    private final Map<String, FacetMetadata> facetFieldNameToFacetMetadata;
    private final Map<String, PropertyMetadata> propertyGetterNameToPropertyMetadata;
    private final PropertyMetadata idPropertyMetadata;
    private final Set<DocumentFieldMetadata> classBridgeFields;
    private final Map<String, DocumentFieldMetadata> classBridgeFieldNameToDocumentFieldMetadata;
    private final Set<EmbeddedTypeMetadata> embeddedTypeMetadata;
    private final Set<ContainedInMetadata> containedInMetadata;
    private final ScopedAnalyzerReference scopedAnalyzerReference;
    private boolean stateInspectionOptimizationsEnabled;
    private final Set<String> collectionRoles;
    private final boolean jpaIdUsedAsDocumentId;
    private final Set<XClass> optimizationBlackList;
    private final Set<SortableFieldMetadata> classBridgeSortableFieldMetadata;

    protected TypeMetadata(Builder builder) {
        this.type = builder.indexedType;
        this.boost = builder.boost;
        this.scopedAnalyzerReference = builder.scopedAnalyzerReferenceBuilder == null ? null : builder.scopedAnalyzerReferenceBuilder.build();
        this.discriminator = builder.discriminator;
        this.discriminatorGetter = builder.discriminatorGetter;
        this.classBoostStrategy = builder.classBoostStrategy;
        this.stateInspectionOptimizationsEnabled = builder.stateInspectionOptimizationsEnabled;
        this.idPropertyMetadata = builder.idPropertyMetadata;
        this.embeddedTypeMetadata = Collections.unmodifiableSet(builder.embeddedTypeMetadata);
        this.containedInMetadata = Collections.unmodifiableSet(builder.containedInMetadata);
        this.optimizationBlackList = Collections.unmodifiableSet(builder.optimizationClassList);
        this.collectionRoles = Collections.unmodifiableSet(builder.collectionRoles);
        this.jpaIdUsedAsDocumentId = this.determineWhetherDocumentIdPropertyIsTheSameAsJpaIdProperty(builder.jpaProperty);
        this.classBridgeFields = Collections.unmodifiableSet(builder.classBridgeFields);
        this.propertyMetadata = Collections.unmodifiableSet(builder.propertyMetadataSet);
        this.propertyGetterNameToPropertyMetadata = this.buildPropertyMetadataMap(builder.propertyMetadataSet);
        this.documentFieldMetadata = this.collectFieldMetadata(builder.propertyMetadataSet, builder.classBridgeFields, builder.idPropertyMetadata);
        this.documentFieldNameToFieldMetadata = this.buildFieldMetadataMap(this.documentFieldMetadata);
        this.facetFieldNameToFacetMetadata = this.buildFacetMetadataMap(this.documentFieldMetadata);
        this.bridgeDefinedFieldNameToFieldMetadata = this.buildBridgeDefinedFieldMetadataMap(this.documentFieldNameToFieldMetadata.values());
        this.classBridgeFieldNameToDocumentFieldMetadata = this.copyClassBridgeMetadata(builder.classBridgeFields);
        this.classBridgeSortableFieldMetadata = Collections.unmodifiableSet(builder.classBridgeSortableFieldMetadata);
    }

    public IndexedTypeIdentifier getType() {
        return this.type;
    }

    public Set<PropertyMetadata> getAllPropertyMetadata() {
        return this.propertyMetadata;
    }

    public PropertyMetadata getPropertyMetadataForProperty(String propertyName) {
        return this.propertyGetterNameToPropertyMetadata.get(propertyName);
    }

    public PropertyMetadata getIdPropertyMetadata() {
        return this.idPropertyMetadata;
    }

    public Set<DocumentFieldMetadata> getClassBridgeMetadata() {
        return this.classBridgeFields;
    }

    public Set<SortableFieldMetadata> getClassBridgeSortableFieldMetadata() {
        return this.classBridgeSortableFieldMetadata;
    }

    public DocumentFieldMetadata getDocumentFieldMetadataFor(String fieldName) {
        DocumentFieldMetadata result = this.documentFieldNameToFieldMetadata.get(fieldName);
        if (result != null) {
            return result;
        }
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            result = element.getDocumentFieldMetadataFor(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public BridgeDefinedField getBridgeDefinedFieldMetadataFor(String fieldName) {
        BridgeDefinedField result = this.bridgeDefinedFieldNameToFieldMetadata.get(fieldName);
        if (result != null) {
            return result;
        }
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            result = element.getBridgeDefinedFieldMetadataFor(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public FacetMetadata getFacetMetadataFor(String facetFieldName) {
        FacetMetadata result = this.facetFieldNameToFacetMetadata.get(facetFieldName);
        if (result != null) {
            return result;
        }
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            result = element.getFacetMetadataFor(facetFieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection<DocumentFieldMetadata> getAllDocumentFieldMetadata() {
        if (this.embeddedTypeMetadata.isEmpty()) {
            return this.documentFieldMetadata;
        }
        ArrayList<DocumentFieldMetadata> allMetadata = new ArrayList<DocumentFieldMetadata>(this.documentFieldMetadata.size());
        for (EmbeddedTypeMetadata element : this.embeddedTypeMetadata) {
            allMetadata.addAll(element.getAllDocumentFieldMetadata());
        }
        allMetadata.addAll(this.documentFieldMetadata);
        return Collections.unmodifiableCollection(allMetadata);
    }

    public Collection<DocumentFieldMetadata> getNonEmbeddedDocumentFieldMetadata() {
        return this.documentFieldMetadata;
    }

    public List<EmbeddedTypeMetadata> getEmbeddedTypeMetadata() {
        return Collections.unmodifiableList(new ArrayList<EmbeddedTypeMetadata>(this.embeddedTypeMetadata));
    }

    public Set<ContainedInMetadata> getContainedInMetadata() {
        return this.containedInMetadata;
    }

    public Collection<XClass> getOptimizationBlackList() {
        return this.optimizationBlackList;
    }

    public boolean containsCollectionRole(String role) {
        for (String knownRolls : this.collectionRoles) {
            if (!this.isSubRole(knownRolls, role)) continue;
            return true;
        }
        return false;
    }

    public boolean areClassBridgesUsed() {
        return !this.classBridgeFieldNameToDocumentFieldMetadata.isEmpty();
    }

    public DocumentFieldMetadata getFieldMetadataForClassBridgeField(String fieldName) {
        return this.classBridgeFieldNameToDocumentFieldMetadata.get(fieldName);
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public XMember getDiscriminatorGetter() {
        return this.discriminatorGetter;
    }

    public boolean areStateInspectionOptimizationsEnabled() {
        return this.stateInspectionOptimizationsEnabled;
    }

    public void disableStateInspectionOptimizations() {
        this.stateInspectionOptimizationsEnabled = false;
    }

    public LuceneOptions getClassLuceneOptions(DocumentFieldMetadata fieldMetadata, float documentLevelBoost) {
        return new LuceneOptionsImpl(fieldMetadata, 1.0f, documentLevelBoost);
    }

    public LuceneOptions getFieldLuceneOptions(PropertyMetadata propertyMetadata, DocumentFieldMetadata fieldMetadata, Object value, float inheritedBoost) {
        return new LuceneOptionsImpl(fieldMetadata, fieldMetadata.getBoost().floatValue() * propertyMetadata.getDynamicBoostStrategy().defineBoost(value), inheritedBoost);
    }

    public BoostStrategy getDynamicBoost() {
        return this.classBoostStrategy;
    }

    public float getStaticBoost() {
        return this.boost;
    }

    public float getClassBoost(Object value) {
        return this.boost * this.classBoostStrategy.defineBoost(value);
    }

    public ScopedAnalyzerReference getDefaultAnalyzerReference() {
        return this.scopedAnalyzerReference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TypeMetadata{");
        sb.append("boost=").append(this.boost);
        sb.append(", discriminator=").append(this.discriminator);
        sb.append(", discriminatorGetter=").append(this.discriminatorGetter);
        sb.append(", classBoostStrategy=").append(this.classBoostStrategy);
        sb.append(", documentFieldNameToFieldMetadata=").append(this.documentFieldNameToFieldMetadata);
        sb.append(", propertyGetterNameToFieldMetadata=").append(this.propertyGetterNameToPropertyMetadata);
        sb.append(", idPropertyMetadata=").append(this.idPropertyMetadata);
        sb.append(", classBridgeFields=").append(this.classBridgeFieldNameToDocumentFieldMetadata);
        sb.append(", embeddedTypeMetadata=").append(this.embeddedTypeMetadata);
        sb.append(", containedInMetadata=").append(this.containedInMetadata);
        sb.append(", optimizationBlackList=").append(this.optimizationBlackList);
        sb.append(", stateInspectionOptimizationsEnabled=").append(this.stateInspectionOptimizationsEnabled);
        sb.append(", scopedAnalyzerReference=").append(this.scopedAnalyzerReference);
        sb.append(", collectionRoles=").append(this.collectionRoles);
        sb.append('}');
        return sb.toString();
    }

    private boolean isSubRole(String subRole, String role) {
        if (role.equals(subRole)) {
            return true;
        }
        return role.startsWith(subRole + COMPONENT_PATH_SEPARATOR);
    }

    private boolean determineWhetherDocumentIdPropertyIsTheSameAsJpaIdProperty(XProperty jpaIdProperty) {
        if (this.idPropertyMetadata == null) {
            return false;
        }
        if (jpaIdProperty == null) {
            return false;
        }
        return jpaIdProperty.equals(this.idPropertyMetadata.getPropertyAccessor());
    }

    private Map<String, PropertyMetadata> buildPropertyMetadataMap(Set<PropertyMetadata> propertyMetadataSet) {
        LinkedHashMap<String, PropertyMetadata> tmpMap = new LinkedHashMap<String, PropertyMetadata>();
        for (PropertyMetadata propertyMetadata : propertyMetadataSet) {
            tmpMap.put(propertyMetadata.getPropertyAccessorName(), propertyMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Set<DocumentFieldMetadata> collectFieldMetadata(Set<PropertyMetadata> propertyMetadataSet, Set<DocumentFieldMetadata> classBridgeFields, PropertyMetadata idPropertyMetadata) {
        LinkedHashSet<DocumentFieldMetadata> tmpSet = new LinkedHashSet<DocumentFieldMetadata>();
        for (PropertyMetadata propertyMetadata : propertyMetadataSet) {
            for (DocumentFieldMetadata documentFieldMetadata : propertyMetadata.getFieldMetadataSet()) {
                tmpSet.add(documentFieldMetadata);
            }
        }
        for (DocumentFieldMetadata documentFieldMetadata : classBridgeFields) {
            tmpSet.add(documentFieldMetadata);
        }
        if (idPropertyMetadata != null) {
            for (DocumentFieldMetadata documentFieldMetadata : idPropertyMetadata.getFieldMetadataSet()) {
                tmpSet.add(documentFieldMetadata);
            }
        }
        return Collections.unmodifiableSet(tmpSet);
    }

    private Map<String, DocumentFieldMetadata> buildFieldMetadataMap(Set<DocumentFieldMetadata> documentFieldMetadataSet) {
        LinkedHashMap<String, DocumentFieldMetadata> tmpMap = new LinkedHashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata documentFieldMetadata : documentFieldMetadataSet) {
            DocumentFieldMetadata oldFieldMetadata;
            String name = documentFieldMetadata.getAbsoluteName();
            if (StringHelper.isEmpty(name) || (oldFieldMetadata = tmpMap.put(name, documentFieldMetadata)) == null || documentFieldMetadata.getIndex().equals((Object)oldFieldMetadata.getIndex())) continue;
            PropertyMetadata sourceProperty = documentFieldMetadata.getSourceProperty();
            String sourceTypeName = sourceProperty != null ? sourceProperty.getPropertyAccessor().getDeclaringClass().getName() : documentFieldMetadata.getSourceTypeIdentifier().getName();
            log.inconsistentFieldConfiguration(sourceTypeName, name);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Map<String, FacetMetadata> buildFacetMetadataMap(Collection<DocumentFieldMetadata> documentFieldMetadataCollection) {
        LinkedHashMap<String, FacetMetadata> tmpMap = new LinkedHashMap<String, FacetMetadata>();
        for (DocumentFieldMetadata documentFieldMetadata : documentFieldMetadataCollection) {
            for (FacetMetadata facetMetadata : documentFieldMetadata.getFacetMetadata()) {
                tmpMap.put(facetMetadata.getAbsoluteName(), facetMetadata);
            }
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Map<String, BridgeDefinedField> buildBridgeDefinedFieldMetadataMap(Collection<DocumentFieldMetadata> documentFieldMetadataCollection) {
        LinkedHashMap<String, BridgeDefinedField> tmpMap = new LinkedHashMap<String, BridgeDefinedField>();
        for (DocumentFieldMetadata documentFieldMetadata : documentFieldMetadataCollection) {
            for (BridgeDefinedField bridgeDefinedField : documentFieldMetadata.getBridgeDefinedFields().values()) {
                tmpMap.put(bridgeDefinedField.getAbsoluteName(), bridgeDefinedField);
            }
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    private Map<String, DocumentFieldMetadata> copyClassBridgeMetadata(Set<DocumentFieldMetadata> classBridgeFields) {
        LinkedHashMap<String, DocumentFieldMetadata> tmpMap = new LinkedHashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata fieldMetadata : classBridgeFields) {
            tmpMap.put(fieldMetadata.getAbsoluteName(), fieldMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    public boolean isJpaIdUsedAsDocumentId() {
        return this.jpaIdUsedAsDocumentId;
    }

    public static class Builder {
        protected final BackReference<TypeMetadata> resultReference = new BackReference();
        private final IndexedTypeIdentifier indexedType;
        private final ScopedAnalyzerReference.Builder scopedAnalyzerReferenceBuilder;
        private final MutableAnalyzerRegistry analyzerRegistry;
        private float boost;
        private BoostStrategy classBoostStrategy;
        private Discriminator discriminator;
        private XMember discriminatorGetter;
        private boolean stateInspectionOptimizationsEnabled = true;
        private final Set<PropertyMetadata> propertyMetadataSet = new LinkedHashSet<PropertyMetadata>();
        private final Set<DocumentFieldMetadata> classBridgeFields = new LinkedHashSet<DocumentFieldMetadata>();
        private final Set<EmbeddedTypeMetadata> embeddedTypeMetadata = new LinkedHashSet<EmbeddedTypeMetadata>();
        private final Set<ContainedInMetadata> containedInMetadata = new LinkedHashSet<ContainedInMetadata>();
        private final Set<XClass> optimizationClassList = new LinkedHashSet<XClass>();
        private final Set<String> collectionRoles = new TreeSet<String>();
        private PropertyMetadata idPropertyMetadata;
        private XProperty jpaProperty;
        private final Set<SortableFieldMetadata> classBridgeSortableFieldMetadata = new LinkedHashSet<SortableFieldMetadata>();

        public Builder(IndexedTypeIdentifier indexedType, ConfigContext configContext, ParseContext parseContext) {
            this.indexedType = indexedType;
            if (parseContext.skipAnalyzers()) {
                this.analyzerRegistry = null;
                this.scopedAnalyzerReferenceBuilder = null;
            } else {
                IndexManagerType indexManagerType = parseContext.getIndexManagerType();
                this.analyzerRegistry = configContext.forType(indexManagerType).getAnalyzerRegistry();
                this.scopedAnalyzerReferenceBuilder = this.analyzerRegistry.buildScopedAnalyzerReference();
            }
        }

        public Builder(IndexedTypeIdentifier indexedType, Builder containerTypeBuilder) {
            this.indexedType = indexedType;
            this.analyzerRegistry = containerTypeBuilder.analyzerRegistry;
            this.scopedAnalyzerReferenceBuilder = containerTypeBuilder.scopedAnalyzerReferenceBuilder;
        }

        public Builder idProperty(PropertyMetadata propertyMetadata) {
            this.idPropertyMetadata = propertyMetadata;
            return this;
        }

        public Builder boost(float boost) {
            this.boost = boost;
            return this;
        }

        public Builder boostStrategy(BoostStrategy boostStrategy) {
            this.classBoostStrategy = boostStrategy;
            return this;
        }

        public Builder analyzerReference(AnalyzerReference analyzerReference) {
            this.scopedAnalyzerReferenceBuilder.setGlobalAnalyzerReference(analyzerReference);
            return this;
        }

        public Builder jpaProperty(XProperty jpaProperty) {
            this.jpaProperty = jpaProperty;
            return this;
        }

        public Builder analyzerDiscriminator(Discriminator discriminator, XMember discriminatorGetter) {
            if (this.discriminator != null) {
                throw new SearchException("Multiple AnalyzerDiscriminator defined in the same class hierarchy: " + this.indexedType.getName());
            }
            this.discriminator = discriminator;
            this.discriminatorGetter = discriminatorGetter;
            return this;
        }

        public Builder addProperty(PropertyMetadata propertyMetadata) {
            if (this.idPropertyMetadata != null && this.idPropertyMetadata.getPropertyAccessorName() != null) {
                String idFieldName = this.idPropertyMetadata.getFieldMetadataSet().iterator().next().getAbsoluteName();
                for (DocumentFieldMetadata fieldMetadata : propertyMetadata.getFieldMetadataSet()) {
                    if (!idFieldName.equals(fieldMetadata.getAbsoluteName())) continue;
                    throw log.fieldTriesToOverrideIdFieldSettings(propertyMetadata.getPropertyAccessor().getDeclaringClass().getName(), propertyMetadata.getPropertyAccessor().getName());
                }
            }
            this.propertyMetadataSet.add(propertyMetadata);
            return this;
        }

        public void addClassBridgeField(DocumentFieldMetadata fieldMetadata) {
            this.classBridgeFields.add(fieldMetadata);
        }

        public void addEmbeddedType(EmbeddedTypeMetadata embeddedTypeMetadata) {
            this.embeddedTypeMetadata.add(embeddedTypeMetadata);
        }

        public void addContainedIn(ContainedInMetadata containedInMetadata) {
            this.containedInMetadata.add(containedInMetadata);
        }

        public void addCollectionRole(String role) {
            this.collectionRoles.add(role);
        }

        public void disableStateInspectionOptimization() {
            this.stateInspectionOptimizationsEnabled = false;
        }

        public AnalyzerReference addToScopedAnalyzerReference(DocumentFieldPath fieldPath, AnalyzerReference analyzerReference, Field.Index index) {
            if (!index.isAnalyzed()) {
                analyzerReference = this.analyzerRegistry.getPassThroughAnalyzerReference();
            } else if (analyzerReference == null) {
                analyzerReference = this.scopedAnalyzerReferenceBuilder.getGlobalAnalyzerReference();
            }
            this.scopedAnalyzerReferenceBuilder.addAnalyzerReference(fieldPath.getAbsoluteName(), analyzerReference);
            return analyzerReference;
        }

        public void blacklistForOptimization(XClass blackListClass) {
            this.optimizationClassList.add(blackListClass);
        }

        public boolean areClassBridgesUsed() {
            return !this.classBridgeFields.isEmpty();
        }

        public BoostStrategy getClassBoostStrategy() {
            return this.classBoostStrategy;
        }

        public AnalyzerReference getAnalyzerReference() {
            return this.scopedAnalyzerReferenceBuilder.getGlobalAnalyzerReference();
        }

        public ScopedAnalyzerReference.Builder getScopedAnalyzerReferenceBuilder() {
            return this.scopedAnalyzerReferenceBuilder;
        }

        public boolean isStateInspectionOptimizationsEnabled() {
            return this.stateInspectionOptimizationsEnabled;
        }

        public IndexedTypeIdentifier getIndexedType() {
            return this.indexedType;
        }

        public PropertyMetadata getIdPropertyMetadata() {
            return this.idPropertyMetadata;
        }

        public BackReference<TypeMetadata> getResultReference() {
            return this.resultReference;
        }

        public TypeMetadata build() {
            TypeMetadata result = new TypeMetadata(this);
            this.resultReference.initialize(result);
            return result;
        }

        public String toString() {
            return "TypeMetadata.Builder{indexedType=" + this.indexedType + "}";
        }

        public void addClassBridgeSortableFields(Iterable<String> sortableFieldsAbsoluteNames) {
            for (String sortableFieldAbsoluteName : sortableFieldsAbsoluteNames) {
                this.classBridgeSortableFieldMetadata.add(new SortableFieldMetadata.Builder(sortableFieldAbsoluteName).build());
            }
        }
    }
}

