/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v1;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.RemotingMBeanServerConnection;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.v1.Common;
import org.jboss.remotingjmx.protocol.v1.ConnectionIdReceiver;
import org.jboss.remotingjmx.protocol.v1.VersionOne;
import org.jboss.remotingjmx.protocol.v1.VersionedIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class ClientConnection
extends Common
implements VersionedConnection {
    private static final String REMOTING_JMX = "remoting-jmx";
    private static final String CLIENT_THREAD = "client-thread-";
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
    public static final int DEFAULT_TIMEOUT = 60;
    private static final Logger log = Logger.getLogger(ClientConnection.class);
    private final Channel channel;
    private final Map<Byte, Common.MessageHandler> handlerRegistry;
    private boolean manageExecutor = false;
    private final Executor executor;
    private final int timeoutSeconds;
    private String connectionId;
    private TheConnection mbeanServerConnection;
    private LocalNotificationManager localNotificationManager;
    private int nextCorrelationId = 1;
    static final ThreadGroup THREAD_GROUP = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

        @Override
        public ThreadGroup run() {
            ThreadGroup t = Thread.currentThread().getThreadGroup();
            while (t.getParent() != null) {
                t = t.getParent();
            }
            return t;
        }
    });
    private final Map<Integer, VersionedIoFuture> requests = new HashMap<Integer, VersionedIoFuture>();

    ClientConnection(Channel channel, Map<String, ?> environment) {
        super(channel);
        this.channel = channel;
        this.handlerRegistry = this.createHandlerRegistry();
        Integer seconds = null;
        if (environment != null && environment.containsKey("org.jboss.remoting-jmx.timeout")) {
            Object timeout = environment.get("org.jboss.remoting-jmx.timeout");
            if (timeout instanceof Number) {
                seconds = ((Number)timeout).intValue();
            } else if (timeout instanceof String) {
                try {
                    seconds = Integer.parseInt((String)timeout);
                }
                catch (NumberFormatException e) {
                    log.warnf((Throwable)e, "Could not parse configured timeout %s", timeout);
                }
            } else {
                log.warnf("Timeout %s configured via environment is not valid ", timeout);
            }
        } else {
            seconds = Integer.getInteger("org.jboss.remoting-jmx.timeout", 60);
        }
        if (environment != null && environment.containsKey(Executor.class.getName())) {
            this.executor = (Executor)environment.get(Executor.class.getName());
        } else {
            this.executor = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(THREAD_GROUP, r, "remoting-jmx client-thread-" + THREAD_NUMBER.getAndIncrement());
                }
            });
            this.manageExecutor = true;
        }
        this.timeoutSeconds = seconds == null ? 60 : seconds;
    }

    private Map<Byte, Common.MessageHandler> createHandlerRegistry() {
        HashMap<Byte, Common.MessageHandler> registry = new HashMap<Byte, Common.MessageHandler>();
        registry.put((byte)-111, new MarshalledResponseHandler(0));
        registry.put((byte)-127, new MarshalledResponseHandler(12));
        registry.put((byte)-120, new MarshalledResponseHandler(4));
        registry.put((byte)-119, new MarshalledResponseHandler(2));
        registry.put((byte)-115, new StringResponseHandler());
        registry.put((byte)-114, new StringArrayResponseHandler());
        registry.put((byte)-121, new IntegerResponseHandler());
        registry.put((byte)-113, new MarshalledResponseHandler(14));
        registry.put((byte)-125, new MarshalledResponseHandler(12));
        registry.put((byte)-112, new BooleanResponseHandler());
        registry.put((byte)-122, new BooleanResponseHandler());
        registry.put((byte)-116, new MarshalledResponseHandler(4));
        registry.put((byte)-124, new MarshalledResponseHandler(13));
        registry.put((byte)-123, new MarshalledResponseHandler(15));
        registry.put((byte)-110, new MarshalledResponseHandler(0));
        registry.put((byte)-118, new MarshalledResponseHandler(0));
        registry.put((byte)-117, new MarshalledResponseHandler(2));
        registry.put((byte)-126, new MarshalledResponseHandler(0));
        registry.put((byte)19, new NotificationHandler());
        return Collections.unmodifiableMap(registry);
    }

    void start() throws IOException {
        this.sendVersionHeader();
        IoFuture<String> futureConnectionId = ConnectionIdReceiver.getConnectionId(this.channel);
        IoFuture.Status result = futureConnectionId.await((long)this.timeoutSeconds, TimeUnit.SECONDS);
        switch (result) {
            case DONE: {
                this.connectionId = (String)futureConnectionId.get();
                this.mbeanServerConnection = new TheConnection();
                this.localNotificationManager = new LocalNotificationManager();
                this.channel.receiveMessage((Channel.Receiver)new MessageReceiver());
                break;
            }
            case FAILED: {
                throw futureConnectionId.getException();
            }
            default: {
                throw new IOException("Unable to obtain connectionId, status=" + result.toString());
            }
        }
    }

    private void sendVersionHeader() throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeBytes("JMX");
                output.writeByte(VersionOne.getVersionIdentifier());
            }
        });
    }

    @Override
    public String getConnectionId() {
        if (this.connectionId == null) {
            throw new IllegalStateException("Connection ID not set");
        }
        return this.connectionId;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject subject) {
        if (subject != null) {
            throw new UnsupportedOperationException("Subject delegation not supported for getMBeanServerConnection");
        }
        return this.mbeanServerConnection;
    }

    @Override
    public void close() {
        if (this.manageExecutor && this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    private synchronized int getNextCorrelationId() {
        int next;
        if ((next = this.nextCorrelationId++) < 0) {
            this.nextCorrelationId = 2;
            next = 1;
        }
        return next;
    }

    private synchronized int reserveNextCorrelationId(VersionedIoFuture future) {
        Integer next = this.getNextCorrelationId();
        while (this.requests.containsKey(next)) {
            next = this.getNextCorrelationId();
        }
        this.requests.put(next, future);
        return next;
    }

    private synchronized <T> VersionedIoFuture<T> getFuture(int correlationId) {
        return this.requests.get(correlationId);
    }

    private synchronized void releaseCorrelationId(int correlationId) {
        this.requests.remove(correlationId);
    }

    private synchronized void cancelAllRequests(IOException io) {
        for (VersionedIoFuture current : this.requests.values()) {
            current.setException(io);
        }
        this.requests.clear();
    }

    private class NotificationHandler
    implements Common.MessageHandler {
        private NotificationHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace((Object)"Notification");
            byte paramType = input.readByte();
            if (paramType != 11) {
                throw new IOException("Unexpected paramType");
            }
            int listenerId = input.readInt();
            paramType = input.readByte();
            if (paramType != 17) {
                throw new IOException("Unexpected paramType");
            }
            try {
                Unmarshaller unmarshaller = ClientConnection.this.prepareForUnMarshalling(input);
                Notification notification = (Notification)unmarshaller.readObject(Notification.class);
                paramType = unmarshaller.readByte();
                if (paramType != 4) {
                    throw new IOException("Unexpected paramType");
                }
                Object handBack = unmarshaller.readObject();
                ClientConnection.this.localNotificationManager.notify(listenerId, notification, handBack);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        }
    }

    private class MarshalledResponseHandler<T>
    extends BaseResponseHandler<T> {
        private final byte expectedType;

        private MarshalledResponseHandler(byte expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        protected byte getExpectedType() {
            return this.expectedType;
        }

        @Override
        protected T readValue(DataInput input) throws IOException {
            Unmarshaller unmarshaller = ClientConnection.this.prepareForUnMarshalling(input);
            try {
                return (T)unmarshaller.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
        }
    }

    private class StringArrayResponseHandler
    extends BaseResponseHandler<String[]> {
        private StringArrayResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 9;
        }

        @Override
        protected String[] readValue(DataInput input) throws IOException {
            int count = input.readInt();
            String[] response = new String[count];
            for (int i = 0; i < count; ++i) {
                response[i] = input.readUTF();
            }
            return response;
        }
    }

    private class StringResponseHandler
    extends BaseResponseHandler<String> {
        private StringResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 8;
        }

        @Override
        protected String readValue(DataInput input) throws IOException {
            return input.readUTF();
        }
    }

    private class IntegerResponseHandler
    extends BaseResponseHandler<Integer> {
        private IntegerResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 11;
        }

        @Override
        protected Integer readValue(DataInput input) throws IOException {
            return input.readInt();
        }
    }

    private class BooleanResponseHandler
    extends BaseResponseHandler<Boolean> {
        private BooleanResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 10;
        }

        @Override
        protected Boolean readValue(DataInput input) throws IOException {
            return input.readBoolean();
        }
    }

    private abstract class BaseResponseHandler<T>
    implements Common.MessageHandler {
        private BaseResponseHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) {
            VersionedIoFuture future = ClientConnection.this.getFuture(correlationId);
            try {
                TypeExceptionHolder response = new TypeExceptionHolder();
                byte outcome = input.readByte();
                if (outcome == 0) {
                    byte expectedType = this.getExpectedType();
                    if (expectedType != 0) {
                        byte parameterType = input.readByte();
                        if (parameterType != expectedType) {
                            throw new IOException("Unexpected response parameter received.");
                        }
                        response.value = this.readValue(input);
                    }
                } else if (outcome == 1) {
                    byte parameterType = input.readByte();
                    if (parameterType != 3) {
                        throw new IOException("Unexpected response parameter received.");
                    }
                    Unmarshaller unmarshaller = ClientConnection.this.prepareForUnMarshalling(input);
                    response.e = (Exception)unmarshaller.readObject(Exception.class);
                } else {
                    future.setException(new IOException("Outcome not understood"));
                }
                future.setResult(response);
            }
            catch (ClassCastException e) {
                future.setException(new IOException(e));
            }
            catch (ClassNotFoundException e) {
                future.setException(new IOException(e));
            }
            catch (IOException e) {
                future.setException(e);
            }
        }

        protected abstract byte getExpectedType();

        protected abstract T readValue(DataInput var1) throws IOException;
    }

    private class TypeExceptionHolder<T> {
        private T value;
        private Exception e;

        private TypeExceptionHolder() {
        }
    }

    private class TheConnection
    implements RemotingMBeanServerConnection {
        private TheConnection() {
        }

        @Override
        public Connection getConnection() {
            return ClientConnection.this.channel.getConnection();
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(2);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(3);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)loaderName);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        this.instanceNotFoundException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final Object[] params, final String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(4);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(5);
                        marshaller.writeInt(params.length);
                        for (Object object : params) {
                            marshaller.writeObject(object);
                        }
                        marshaller.writeByte(9);
                        marshaller.writeInt(signature.length);
                        for (String string : signature) {
                            marshaller.writeUTF(string);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final ObjectName loaderName, final Object[] params, final String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(5);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)loaderName);
                        marshaller.writeByte(5);
                        marshaller.writeInt(params.length);
                        for (Object object : params) {
                            marshaller.writeObject(object);
                        }
                        marshaller.writeByte(9);
                        marshaller.writeInt(signature.length);
                        for (String string : signature) {
                            marshaller.writeUTF(string);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void unregisterMBean(final ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(2);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] unregisterMBean - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke unregisterMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance getObjectInstance(final ObjectName name) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(3);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getObjectInstance - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.instanceNotFoundException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke getObjectInstance, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Set<ObjectInstance> queryMBeans(final ObjectName name, final QueryExp query) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(4);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(7);
                        marshaller.writeObject((Object)query);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] queryMBeans - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Set set = (Set)response.value;
                            return set;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke queryMBeans, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Set<ObjectName> queryNames(final ObjectName name, final QueryExp query) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(5);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(7);
                        marshaller.writeObject((Object)query);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] queryNames - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Set set = (Set)response.value;
                            return set;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public boolean isRegistered(final ObjectName name) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(6);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] isRegistered - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            boolean bl = (Boolean)response.value;
                            return bl;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(7);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getMBeanCount - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Integer n = (Integer)response.value;
                            return n;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain MBeanCount, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Object getAttribute(final ObjectName name, final String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(8);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(attribute);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getAttribute - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Object object = response.value;
                            return object;
                        }
                        this.mbeanException(response.e);
                        this.attributeNotFoundException(response.e);
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public AttributeList getAttributes(final ObjectName name, final String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(9);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(9);
                        marshaller.writeInt(attributes.length);
                        for (String current : attributes) {
                            marshaller.writeUTF(current);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getAttributes - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            AttributeList attributeList = (AttributeList)response.value;
                            return attributeList;
                        }
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke getAttributes, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void setAttribute(final ObjectName name, final Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(10);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(1);
                        marshaller.writeObject((Object)attribute);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] setAttribute - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.attributeNotFoundException(response.e);
                        this.invalidAttributeValueException(response.e);
                        this.mbeanException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke setAttribute, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public AttributeList setAttributes(final ObjectName name, final AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(11);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(2);
                        marshaller.writeObject((Object)attributes);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] setAttributes - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            AttributeList attributeList = (AttributeList)response.value;
                            return attributeList;
                        }
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke setAttributes, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Object invoke(final ObjectName name, final String operationName, final Object[] params, final String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(12);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(operationName);
                        marshaller.writeByte(5);
                        if (params != null) {
                            marshaller.writeInt(params.length);
                            for (Object object : params) {
                                marshaller.writeObject(object);
                            }
                        } else {
                            marshaller.writeInt(0);
                        }
                        marshaller.writeByte(9);
                        if (signature != null) {
                            marshaller.writeInt(signature.length);
                            for (String string : signature) {
                                marshaller.writeUTF(string);
                            }
                        } else {
                            marshaller.writeInt(0);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] invoke - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Object object = response.value;
                            return object;
                        }
                        this.instanceNotFoundException(response.e);
                        this.mbeanException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke invoke(), status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public String getDefaultDomain() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(13);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getDefaultDomain - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            String string = (String)response.value;
                            return string;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain DefaultDomain, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(14);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getDomains - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            String[] stringArray = (String[])response.value;
                            return stringArray;
                        }
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain Domains, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void addNotificationListener(final ObjectName name, NotificationListener listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, IOException {
            final int notificationId = ClientConnection.this.localNotificationManager.associate(name, listener, filter, handback);
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(17);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(11);
                        marshaller.writeInt(notificationId);
                        marshaller.writeByte(16);
                        marshaller.writeObject((Object)filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] addNotificationListener - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        ClientConnection.this.localNotificationManager.cancel(notificationId);
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        ClientConnection.this.localNotificationManager.cancel(notificationId);
                        this.instanceNotFoundException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                ClientConnection.this.localNotificationManager.cancel(notificationId);
                throw new IOException("Unable to invoke addNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void addNotificationListener(final ObjectName name, final ObjectName listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(17);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)listener);
                        marshaller.writeByte(16);
                        marshaller.writeObject((Object)filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] addNotificationListener - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.jmRuntimeException(response.e);
                        this.instanceNotFoundException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke addNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(final ObjectName name, final ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(2);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)listener);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.jmRuntimeException(response.e);
                        this.instanceNotFoundException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(final ObjectName name, final ObjectName listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(4);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(6);
                        marshaller.writeObject((Object)listener);
                        marshaller.writeByte(16);
                        marshaller.writeObject((Object)filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.jmRuntimeException(response.e);
                        this.instanceNotFoundException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        private void removeNotificationListener(final int[] listenerIds) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(1);
                        output.writeByte(18);
                        output.writeInt(listenerIds.length);
                        for (int current : listenerIds) {
                            output.writeInt(current);
                        }
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.listenerNotFoundException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.removeNotificationListener(ClientConnection.this.localNotificationManager.matchToRemove(name, listener));
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.removeNotificationListener(ClientConnection.this.localNotificationManager.matchToRemove(name, listener, filter, handback));
        }

        @Override
        public MBeanInfo getMBeanInfo(final ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(15);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getMBeanInfo - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            MBeanInfo mBeanInfo = (MBeanInfo)response.value;
                            return mBeanInfo;
                        }
                        this.instanceNotFoundException(response.e);
                        this.introspectionException(response.e);
                        this.reflectionException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public boolean isInstanceOf(final ObjectName name, final String className) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(16);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                    }
                });
                log.tracef("[%d] isInstanceOf - Request Sent", correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        TypeExceptionHolder response = (TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            boolean bl = (Boolean)response.value;
                            return bl;
                        }
                        this.instanceNotFoundException(response.e);
                        this.jmRuntimeException(response.e);
                        throw this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.releaseCorrelationId(correlationId);
            }
        }

        private void attributeNotFoundException(Exception e) throws AttributeNotFoundException {
            if (e != null && e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
        }

        private void instanceAlreadyExistsException(Exception e) throws InstanceAlreadyExistsException {
            if (e != null && e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
        }

        private void instanceNotFoundException(Exception e) throws InstanceNotFoundException {
            if (e != null && e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
        }

        private void introspectionException(Exception e) throws IntrospectionException {
            if (e != null && e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
        }

        private void invalidAttributeValueException(Exception e) throws InvalidAttributeValueException {
            if (e != null && e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
        }

        private void listenerNotFoundException(Exception e) throws ListenerNotFoundException {
            if (e != null && e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
        }

        private void mbeanRegistrationException(Exception e) throws MBeanRegistrationException {
            if (e != null && e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
        }

        private void mbeanException(Exception e) throws MBeanException {
            if (e != null && e instanceof MBeanException) {
                throw (MBeanException)e;
            }
        }

        private void notCompliantMBeanException(Exception e) throws NotCompliantMBeanException {
            if (e != null && e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
        }

        private void reflectionException(Exception e) throws ReflectionException {
            if (e != null && e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
        }

        private void jmRuntimeException(Exception e) {
            if (e instanceof JMRuntimeException) {
                throw (JMRuntimeException)e;
            }
        }

        private IOException toIoException(Exception e) {
            if (e instanceof IOException) {
                return (IOException)e;
            }
            return new IOException("Unexpected failure", e);
        }
    }

    private class MessageReceiver
    implements Channel.Receiver {
        private MessageReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            block6: {
                final DataInputStream dis = new DataInputStream((InputStream)message);
                try {
                    byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (int)messageId, correlationId);
                    final Common.MessageHandler mh = (Common.MessageHandler)ClientConnection.this.handlerRegistry.get(messageId);
                    if (mh != null) {
                        ClientConnection.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    mh.handle(dis, correlationId);
                                }
                                catch (IOException e) {
                                    log.error((Object)e);
                                }
                                finally {
                                    IoUtils.safeClose((Closeable)dis);
                                }
                            }
                        });
                        break block6;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (IOException e) {
                    log.error((Object)e);
                    IoUtils.safeClose((Closeable)dis);
                }
                finally {
                    channel.receiveMessage((Channel.Receiver)this);
                }
            }
        }

        public void handleError(Channel channel, IOException error) {
            ClientConnection.this.cancelAllRequests(error);
        }

        public void handleEnd(Channel channel) {
            ClientConnection.this.cancelAllRequests(new IOException("Connection Ended"));
        }
    }

    private class LocalNotificationManager {
        private int nextNotificationId = 1;
        private Map<Integer, Association> listeners = new HashMap<Integer, Association>();

        private LocalNotificationManager() {
        }

        private synchronized int getNextNotificationId() {
            int next;
            if ((next = this.nextNotificationId++) < 0) {
                this.nextNotificationId = 2;
                next = 1;
            }
            return next;
        }

        private synchronized int associate(ObjectName target, NotificationListener listener, NotificationFilter filter, Object handBack) {
            Integer next = this.getNextNotificationId();
            while (this.listeners.containsKey(next)) {
                next = this.getNextNotificationId();
            }
            Association association = new Association();
            association.target = target;
            association.listener = listener;
            association.filter = filter;
            association.handBack = handBack;
            this.listeners.put(next, association);
            return next;
        }

        private synchronized void cancel(int id) {
            this.listeners.remove(id);
        }

        private synchronized Association get(int id) {
            return this.listeners.get(id);
        }

        private void notify(int id, Notification n, Object handback) {
            Association association = this.get(id);
            if (association != null) {
                association.listener.handleNotification(n, handback);
            } else {
                try {
                    log.warnf("Notification recieved for non existant NotificationListener %d", (Object)id);
                    ClientConnection.this.mbeanServerConnection.removeNotificationListener(new int[]{id});
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private synchronized int[] matchToRemove(ObjectName name, NotificationListener listener) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer current : this.listeners.keySet()) {
                Association association = this.listeners.get(current);
                if (name != association.target && (!name.equals(association.target) || listener != association.listener)) continue;
                toRemove.add(current);
            }
            int[] response = new int[toRemove.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = (Integer)toRemove.get(i);
                this.listeners.remove(response[i]);
            }
            return response;
        }

        private synchronized int[] matchToRemove(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer current : this.listeners.keySet()) {
                Association association = this.listeners.get(current);
                if (name != association.target && !name.equals(association.target) || listener != association.listener || filter != association.filter || handback != association.handBack) continue;
                toRemove.add(current);
            }
            int[] response = new int[toRemove.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = (Integer)toRemove.get(i);
                this.listeners.remove(response[i]);
            }
            return response;
        }

        private class Association {
            private ObjectName target;
            private NotificationListener listener;
            private NotificationFilter filter;
            private Object handBack;

            private Association() {
            }
        }
    }
}

