/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterPartitionReassignmentsResponse
extends AbstractResponse {
    private final AlterPartitionReassignmentsResponseData data;

    public AlterPartitionReassignmentsResponse(AlterPartitionReassignmentsResponseData data) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS);
        this.data = data;
    }

    public static AlterPartitionReassignmentsResponse parse(ByteBuffer buffer, short version) {
        return new AlterPartitionReassignmentsResponse(new AlterPartitionReassignmentsResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public AlterPartitionReassignmentsResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topicResponse -> topicResponse.partitions().forEach(partitionResponse -> this.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }
}

