/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javassist.NotFoundException;
import org.hibernate.bytecode.enhance.internal.javassist.FieldWriter;
import org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.hibernate.bytecode.enhance.internal.javassist.MethodWriter;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SelfDirtinessTracker;

public class EntityEnhancer
extends PersistentAttributesEnhancer {
    private static final String DIRTY_TRACKER_IMPL = SimpleFieldTracker.class.getName();
    private static final String COLLECTION_TRACKER_IMPL = SimpleCollectionTracker.class.getName();

    public EntityEnhancer(JavassistEnhancementContext context) {
        super(context);
    }

    @Override
    public void enhance(CtClass managedCtClass) {
        managedCtClass.addInterface(this.loadCtClassFromClass(ManagedEntity.class));
        this.addEntityInstanceHandling(managedCtClass);
        this.addEntityEntryHandling(managedCtClass);
        this.addLinkedPreviousHandling(managedCtClass);
        this.addLinkedNextHandling(managedCtClass);
        this.addInterceptorHandling(managedCtClass);
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
            this.addInLineDirtyHandling(managedCtClass);
        }
        super.enhance(managedCtClass);
    }

    private void addEntityInstanceHandling(CtClass managedCtClass) {
        try {
            MethodWriter.write(managedCtClass, "public Object %s() { return this; }", "$$_hibernate_getEntityInstance");
        }
        catch (CannotCompileException cce) {
            throw new EnhancementException(String.format(Locale.ROOT, "Could not enhance entity class [%s] to add EntityEntry getter", managedCtClass.getName()), cce);
        }
    }

    private void addEntityEntryHandling(CtClass managedCtClass) {
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(EntityEntry.class), "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
    }

    private void addLinkedPreviousHandling(CtClass managedCtClass) {
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(ManagedEntity.class), "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
    }

    private void addLinkedNextHandling(CtClass managedCtClass) {
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(ManagedEntity.class), "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
    }

    private void addInLineDirtyHandling(CtClass managedCtClass) {
        managedCtClass.addInterface(this.loadCtClassFromClass(SelfDirtinessTracker.class));
        FieldWriter.addField(managedCtClass, this.loadCtClassFromClass(DirtyTracker.class), "$$_hibernate_tracker");
        if (this.collectCollectionFields(managedCtClass).isEmpty()) {
            this.createDirtyTrackerMethodsWithoutCollections(managedCtClass);
        } else {
            FieldWriter.addField(managedCtClass, this.loadCtClassFromClass(CollectionTracker.class), "$$_hibernate_collectionTracker");
            this.createDirtyTrackerMethodsWithCollections(managedCtClass);
        }
    }

    private void createDirtyTrackerMethodsWithoutCollections(CtClass managedCtClass) {
        try {
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s == null) { %2$s = new %3$s(); }%n  %2$s.add(name);%n}", "$$_hibernate_trackChange", "$$_hibernate_tracker", DIRTY_TRACKER_IMPL);
            MethodWriter.write(managedCtClass, "public String[] %1$s() {%n  return (%2$s == null) ? new String[0] : %2$s.get();%n}", "$$_hibernate_getDirtyAttributes", "$$_hibernate_tracker");
            MethodWriter.write(managedCtClass, "public boolean %1$s() {%n  return (%2$s != null && !%2$s.isEmpty());%n}", "$$_hibernate_hasDirtyAttributes", "$$_hibernate_tracker");
            MethodWriter.write(managedCtClass, "public void %1$s() {%n  if (%2$s != null) { %2$s.clear(); }%n}", "$$_hibernate_clearDirtyAttributes", "$$_hibernate_tracker");
            MethodWriter.write(managedCtClass, "public void %1$s(boolean f) {%n  if (%2$s == null) %2$s = new %3$s();%n  %2$s.suspend(f);%n}", "$$_hibernate_suspendDirtyTracking", "$$_hibernate_tracker", DIRTY_TRACKER_IMPL);
            MethodWriter.write(managedCtClass, "public %s %s() { return %s.INSTANCE; }", CollectionTracker.class.getName(), "$$_hibernate_getCollectionTracker", NoopCollectionTracker.class.getName());
        }
        catch (CannotCompileException cce) {
            throw new RuntimeException("createDirtyTrackerMethodsWithoutCollections failed", cce);
        }
    }

    private void createDirtyTrackerMethodsWithCollections(CtClass managedCtClass) {
        try {
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s == null) { %2$s = new %3$s(); }%n  %2$s.add(name);%n}", "$$_hibernate_trackChange", "$$_hibernate_tracker", DIRTY_TRACKER_IMPL);
            this.createCollectionDirtyCheckMethod(managedCtClass);
            this.createCollectionDirtyCheckGetFieldsMethod(managedCtClass);
            this.createClearDirtyCollectionMethod(managedCtClass);
            MethodWriter.write(managedCtClass, "public String[] %1$s() {%n  if(%3$s == null) {%n    return (%2$s == null) ? new String[0] : %2$s.get();%n  } else {%n    if (%2$s == null) %2$s = new %5$s();%n    %4$s(%2$s);%n    return %2$s.get();%n  }%n}", "$$_hibernate_getDirtyAttributes", "$$_hibernate_tracker", "$$_hibernate_collectionTracker", "$$_hibernate_getCollectionFieldDirtyNames", DIRTY_TRACKER_IMPL);
            MethodWriter.write(managedCtClass, "public boolean %1$s() {%n  return (%2$s != null && !%2$s.isEmpty()) || %3$s();%n}", "$$_hibernate_hasDirtyAttributes", "$$_hibernate_tracker", "$$_hibernate_areCollectionFieldsDirty");
            MethodWriter.write(managedCtClass, "public void %1$s() {%n  if (%2$s != null) { %2$s.clear(); }%n  %3$s();%n}", "$$_hibernate_clearDirtyAttributes", "$$_hibernate_tracker", "$$_hibernate_clearDirtyCollectionNames");
            MethodWriter.write(managedCtClass, "public void %1$s(boolean f) {%n  if (%2$s == null) %2$s = new %3$s();%n  %2$s.suspend(f);%n}", "$$_hibernate_suspendDirtyTracking", "$$_hibernate_tracker", DIRTY_TRACKER_IMPL);
            MethodWriter.write(managedCtClass, "public %s %s() { return %s; }", CollectionTracker.class.getName(), "$$_hibernate_getCollectionTracker", "$$_hibernate_collectionTracker");
        }
        catch (CannotCompileException cce) {
            throw new RuntimeException("createDirtyTrackerMethodsWithCollections failed", cce);
        }
    }

    private List<CtField> collectCollectionFields(CtClass managedCtClass) {
        ArrayList<CtField> collectionList = new ArrayList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(ctField) || this.enhancementContext.isMappedCollection(ctField) || !PersistentAttributesHelper.isAssignable(ctField, Collection.class.getName()) && !PersistentAttributesHelper.isAssignable(ctField, Map.class.getName())) continue;
            collectionList.add(ctField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            collectionList.addAll(this.collectInheritCollectionFields(managedCtClass));
        }
        return collectionList;
    }

    private Collection<CtField> collectInheritCollectionFields(CtClass managedCtClass) {
        if (managedCtClass == null || Object.class.getName().equals(managedCtClass.getName())) {
            return Collections.emptyList();
        }
        try {
            CtClass managedCtSuperclass = managedCtClass.getSuperclass();
            if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass)) {
                return this.collectInheritCollectionFields(managedCtSuperclass);
            }
            ArrayList<CtField> collectionList = new ArrayList<CtField>();
            for (CtField ctField : managedCtSuperclass.getDeclaredFields()) {
                if (Modifier.isStatic((int)ctField.getModifiers()) || !this.enhancementContext.isPersistentField(ctField) || this.enhancementContext.isMappedCollection(ctField) || !PersistentAttributesHelper.isAssignable(ctField, Collection.class.getName()) && !PersistentAttributesHelper.isAssignable(ctField, Map.class.getName())) continue;
                collectionList.add(ctField);
            }
            collectionList.addAll(this.collectInheritCollectionFields(managedCtSuperclass));
            return collectionList;
        }
        catch (NotFoundException nfe) {
            return Collections.emptyList();
        }
    }

    private void createCollectionDirtyCheckMethod(CtClass managedCtClass) {
        try {
            StringBuilder body = new StringBuilder();
            body.append(String.format("private boolean %1$s() {%n  if (%2$s == null) { return false; }%n%n", "$$_hibernate_areCollectionFieldsDirty", "$$_hibernate_collectionTracker"));
            for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
                body.append(String.format("  // collection field [%1$s]%n  if (%1$s == null && %2$s.getSize(\"%1$s\") != -1) { return true; }%n  if (%1$s != null && %2$s.getSize(\"%1$s\") != %1$s.size()) { return true; }%n%n", ctField.getName(), "$$_hibernate_collectionTracker"));
            }
            body.append("  return false;%n}");
            MethodWriter.write(managedCtClass, body.toString(), new Object[0]);
        }
        catch (CannotCompileException cce) {
            throw new RuntimeException("createCollectionDirtyCheckMethod failed", cce);
        }
    }

    private void createCollectionDirtyCheckGetFieldsMethod(CtClass managedCtClass) {
        try {
            StringBuilder body = new StringBuilder();
            body.append(String.format("private void %1$s(%3$s tracker) {%n  if (%2$s == null) { return; }%n%n", "$$_hibernate_getCollectionFieldDirtyNames", "$$_hibernate_collectionTracker", DirtyTracker.class.getName()));
            for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
                body.append(String.format("  // Collection field [%1$s]%n  if (%1$s == null && %2$s.getSize(\"%1$s\") != -1) { tracker.add(\"%1$s\"); }%n  if (%1$s != null && %2$s.getSize(\"%1$s\") != %1$s.size()) { tracker.add(\"%1$s\"); }%n%n", ctField.getName(), "$$_hibernate_collectionTracker"));
            }
            body.append("}");
            MethodWriter.write(managedCtClass, body.toString(), new Object[0]);
        }
        catch (CannotCompileException cce) {
            throw new RuntimeException("createCollectionDirtyCheckGetFieldsMethod failed", cce);
        }
    }

    private void createClearDirtyCollectionMethod(CtClass managedCtClass) throws CannotCompileException {
        StringBuilder body = new StringBuilder();
        body.append(String.format("private void %1$s() {%n  if (%2$s == null) { %2$s = new %3$s(); }%n  %4$s lazyInterceptor = null;%n", "$$_hibernate_clearDirtyCollectionNames", "$$_hibernate_collectionTracker", COLLECTION_TRACKER_IMPL, LazyAttributeLoadingInterceptor.class.getName()));
        if (PersistentAttributesHelper.isAssignable(managedCtClass, PersistentAttributeInterceptable.class.getName())) {
            body.append(String.format("  if(%1$s != null && %1$s instanceof %2$s) lazyInterceptor = (%2$s) %1$s;%n%n", "$$_hibernate_attributeInterceptor", LazyAttributeLoadingInterceptor.class.getName()));
        }
        for (CtField ctField : this.collectCollectionFields(managedCtClass)) {
            body.append(String.format("  // collection field [%1$s]%n  if (lazyInterceptor == null || lazyInterceptor.isAttributeLoaded(\"%1$s\")) {%n    if (%1$s == null) { %2$s.add(\"%1$s\", -1); }%n    else { %2$s.add(\"%1$s\", %1$s.size()); }%n  }%n%n", ctField.getName(), "$$_hibernate_collectionTracker"));
        }
        body.append("}");
        MethodWriter.write(managedCtClass, body.toString(), new Object[0]);
    }
}

