/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public final class DataFormat {
    private static final Log log = LogFactory.getLog(DataFormat.class, Log.class);
    private final MediaType keyType;
    private final MediaType valueType;
    private final Marshaller keyMarshaller;
    private final Marshaller valueMarshaller;
    private MarshallerRegistry marshallerRegistry;
    private Marshaller defaultMarshaller;
    private boolean isObjectStorage;
    private final BufferSizePredictor keySizePredictor = new AdaptiveBufferSizePredictor();
    private final BufferSizePredictor valueSizePredictor = new AdaptiveBufferSizePredictor();

    private DataFormat(MediaType keyType, MediaType valueType, Marshaller keyMarshaller, Marshaller valueMarshaller) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyMarshaller = keyMarshaller;
        this.valueMarshaller = valueMarshaller;
    }

    public DataFormat withoutValueType() {
        DataFormat dataFormat = new DataFormat(this.keyType, null, this.keyMarshaller, null);
        dataFormat.marshallerRegistry = this.marshallerRegistry;
        dataFormat.defaultMarshaller = this.defaultMarshaller;
        dataFormat.isObjectStorage = this.isObjectStorage;
        return dataFormat;
    }

    public MediaType getKeyType() {
        if (this.keyType != null) {
            return this.keyType;
        }
        Marshaller marshaller = this.resolveKeyMarshaller();
        return marshaller == null ? null : marshaller.mediaType();
    }

    public MediaType getValueType() {
        if (this.valueType != null) {
            return this.valueType;
        }
        Marshaller marshaller = this.resolveValueMarshaller();
        return marshaller == null ? null : marshaller.mediaType();
    }

    @Deprecated
    public void initialize(RemoteCacheManager remoteCacheManager, boolean serverObjectStorage) {
        this.marshallerRegistry = remoteCacheManager.getMarshallerRegistry();
        this.defaultMarshaller = remoteCacheManager.getMarshaller();
        this.isObjectStorage = serverObjectStorage;
    }

    public void initialize(RemoteCacheManager remoteCacheManager, String cacheName, boolean serverObjectStorage) {
        this.marshallerRegistry = remoteCacheManager.getMarshallerRegistry();
        this.isObjectStorage = serverObjectStorage;
        this.defaultMarshaller = remoteCacheManager.getMarshaller();
        RemoteCacheConfiguration remoteCacheConfiguration = remoteCacheManager.getConfiguration().remoteCaches().get(cacheName);
        if (remoteCacheConfiguration != null) {
            Marshaller cacheMarshaller = remoteCacheConfiguration.marshaller();
            if (cacheMarshaller != null) {
                this.defaultMarshaller = cacheMarshaller;
            } else {
                Class<? extends Marshaller> marshallerClass = remoteCacheConfiguration.marshallerClass();
                if (marshallerClass != null) {
                    Marshaller registryMarshaller = this.marshallerRegistry.getMarshaller(marshallerClass);
                    this.defaultMarshaller = registryMarshaller != null ? registryMarshaller : (Marshaller)Util.getInstance(marshallerClass);
                }
            }
        }
    }

    private Marshaller resolveValueMarshaller() {
        if (this.valueMarshaller != null) {
            return this.valueMarshaller;
        }
        if (this.valueType == null) {
            return this.defaultMarshaller;
        }
        Marshaller forValueType = this.marshallerRegistry.getMarshaller(this.valueType);
        if (forValueType != null) {
            return forValueType;
        }
        log.debugf("No marshaller registered for %s, using no-op marshaller", this.valueType);
        return IdentityMarshaller.INSTANCE;
    }

    public boolean isObjectStorage() {
        return this.isObjectStorage;
    }

    private Marshaller resolveKeyMarshaller() {
        if (this.keyMarshaller != null) {
            return this.keyMarshaller;
        }
        if (this.keyType == null) {
            return this.defaultMarshaller;
        }
        Marshaller forKeyType = this.marshallerRegistry.getMarshaller(this.keyType);
        if (forKeyType != null) {
            return forKeyType;
        }
        log.debugf("No marshaller registered for %s, using no-op marshaller", this.keyType);
        return IdentityMarshaller.INSTANCE;
    }

    @Deprecated
    public byte[] keyToBytes(Object key, int estimateKeySize, int estimateValueSize) {
        return this.keyToBytes(key);
    }

    public byte[] keyToBytes(Object key) {
        Marshaller keyMarshaller = this.resolveKeyMarshaller();
        return MarshallerUtil.obj2bytes(keyMarshaller, key, this.keySizePredictor);
    }

    @Deprecated
    public byte[] valueToBytes(Object value, int estimateKeySize, int estimateValueSize) {
        return this.valueToBytes(value);
    }

    public byte[] valueToBytes(Object value) {
        Marshaller valueMarshaller = this.resolveValueMarshaller();
        return MarshallerUtil.obj2bytes(valueMarshaller, value, this.valueSizePredictor);
    }

    public <T> T keyToObj(byte[] bytes, ClassAllowList allowList) {
        Marshaller keyMarshaller = this.resolveKeyMarshaller();
        return MarshallerUtil.bytes2obj(keyMarshaller, bytes, this.isObjectStorage, allowList);
    }

    public <T> T valueToObj(byte[] bytes, ClassAllowList allowList) {
        Marshaller valueMarshaller = this.resolveValueMarshaller();
        return MarshallerUtil.bytes2obj(valueMarshaller, bytes, this.isObjectStorage, allowList);
    }

    public String toString() {
        return "DataFormat{keyType=" + this.keyType + ", valueType=" + this.valueType + ", keyMarshaller=" + this.keyMarshaller + ", valueMarshaller=" + this.valueMarshaller + ", marshallerRegistry=" + this.marshallerRegistry + ", defaultMarshaller=" + this.defaultMarshaller + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MediaType keyType;
        private MediaType valueType;
        private Marshaller valueMarshaller;
        private Marshaller keyMarshaller;

        public Builder from(DataFormat dataFormat) {
            this.keyType = dataFormat.keyType;
            this.valueType = dataFormat.valueType;
            this.keyMarshaller = dataFormat.keyMarshaller;
            this.valueMarshaller = dataFormat.valueMarshaller;
            return this;
        }

        public Builder valueMarshaller(Marshaller valueMarshaller) {
            this.valueMarshaller = valueMarshaller;
            return this;
        }

        public Builder keyMarshaller(Marshaller keyMarshaller) {
            this.keyMarshaller = keyMarshaller;
            return this;
        }

        public Builder keyType(MediaType keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder valueType(MediaType valueType) {
            this.valueType = valueType;
            return this;
        }

        public DataFormat build() {
            return new DataFormat(this.keyType, this.valueType, this.keyMarshaller, this.valueMarshaller);
        }
    }
}

