/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;
import org.wildfly.extension.io.OutboundBindAddressResourceDefinition;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.extension.io.WorkerService;
import org.xnio.XnioWorker;

final class OutboundBindAddressUtils {
    private OutboundBindAddressUtils() {
    }

    static InetSocketAddress getBindAddress(ModelNode operation, OperationContext context) throws OperationFailedException {
        return new InetSocketAddress(Inet.parseInetAddress((String)OutboundBindAddressResourceDefinition.BIND_ADDRESS.resolveModelAttribute(context, operation).asString()), OutboundBindAddressResourceDefinition.BIND_PORT.resolveModelAttribute(context, operation).asInt(0));
    }

    static CidrAddress getCidrAddress(ModelNode operation, OperationContext context) throws OperationFailedException {
        return Inet.parseCidrAddress((String)OutboundBindAddressResourceDefinition.MATCH.resolveModelAttribute(context, operation).asString());
    }

    static WorkerService getWorkerService(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        String workerName = context.getCurrentAddress().getParent().getLastElement().getValue();
        ServiceName workerServiceName = WorkerResourceDefinition.IO_WORKER_RUNTIME_CAPABILITY.getCapabilityServiceName(workerName, XnioWorker.class);
        ServiceController workerServiceController = serviceRegistry.getRequiredService(workerServiceName);
        return (WorkerService)workerServiceController.getService();
    }
}

